<?php

    class Sous_categorie_model extends CI_Model{

        function add($params){
            $this->db->insert("sous_categorie_comptable", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_sous_categorie_comptable", $id);
            return $this->db->update("sous_categorie_comptable", $params);
        }

        function get_all_sous_categorie_comptables(){
            $this->db->order_by('id_sous_categorie_comptable', 'desc');
            return $this->db->get('sous_categorie_comptable')->result_array();
        }

        function get_sous_categorie_comptable_by_id_entreprise($token){
            return $this->db->get_where('sous_categorie_comptable',array('id_foreign_entreprise_salesienne'=>$token))->result_array();
        }

        function get_sous_categorie_comptable($id){
            return $this->db->get_where('sous_categorie_comptable',array('id_sous_categorie_comptable'=>$id))->row_array();
        }

        function get_sous_categorie_comptable_by_code_comptable($code_comptable){
            return $this->db->get_where('sous_categorie_comptable',array('code_comptable'=>$code_comptable))->row_array();
        }

        function get_sous_categorie_comptables_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }

        function delete_sous_categorie_comptable($token){
            $this->db->where("id_sous_categorie_comptable", $token);
            return $this->db->delete("sous_categorie_comptable");
        }

    }

?>