<?php

    class Plan_comptable_model extends CI_Model{

        function add($params){
            $this->db->insert("plan_comptable", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_plan_comptable", $id);
            return $this->db->update("plan_comptable", $params);
        }


        function update_active_state($id, $params){
            $this->db->where("is_active", $id);
            return $this->db->update("plan_comptable", $params);
        }

        function get_all_plan_comptables(){
            $this->db->order_by('id_plan_comptable', 'desc');
            return $this->db->get('plan_comptable')->result_array();
        }

        function get_plan_comptable_by_id_entreprise($token){
            return $this->db->get_where('plan_comptable',array('id_foreign_entreprise_salesienne'=>$token))->result_array();
        }

        function get_plan_comptable($id){
            return $this->db->get_where('plan_comptable',array('id_plan_comptable'=>$id))->row_array();
        }

        function get_plan_comptable_by_is_active($id,$is_active){
            return $this->db->get_where('plan_comptable',array('id_plan_comptable'=>$id,'is_active'=>$is_active))->row_array();
        }

        function get_plan_comptables_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }

        function delete_plan_comptable($token){
            $this->db->where("id_plan_comptable", $token);
            return $this->db->delete("plan_comptable");
        }

    }

?>