<?php

    class Depense_caisse_model extends CI_Model{

        function add($params){
            $this->db->insert("depense_caisse", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_depense_caisse", $id);
            return $this->db->update("depense_caisse", $params);
        }

        function get_all_depense_caisses(){
            $this->db->order_by('id_depense_caisse', 'desc');
            return $this->db->get('depense_caisse')->result_array();
        }

        function get_depense_caisse_by_id_entreprise($token){
            return $this->db->get_where('depense_caisse',array('id_foreign_entreprise_salesienne_depense_caisse'=>$token))->result_array();
        }

        function get_depense_caisse($id){
            return $this->db->get_where('depense_caisse',array('id_depense_caisse'=>$id))->row_array();
        }

        function get_depense_caisses_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }

        function delete_depense_caisse($token){
            $this->db->where("id_depense_caisse", $token);
            return $this->db->delete("depense_caisse");
        }

    }

?>