<?php

    class Categorie_plan_comptable_model extends CI_Model{

        function add($params){
            $this->db->insert("categorie_plan_comptable", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_categorie_plan_comptable", $id);
            return $this->db->update("categorie_plan_comptable", $params);
        }

        function get_all_categorie_plan_comptables(){
            $this->db->order_by('id_categorie_plan_comptable', 'desc');
            return $this->db->get('categorie_plan_comptable')->result_array();
        }

        function get_categorie_plan_comptable_by_id_entreprise($token){
            return $this->db->get_where('categorie_plan_comptable',array('id_foreign_entreprise_salesienne_categorie_plan_comptable'=>$token))->result_array();
        }

        function get_categorie_plan_comptable_by_id_entreprise_id_type($token,$id_type){
            return $this->db->get_where('categorie_plan_comptable',array('id_foreign_entreprise_salesienne_categorie_plan_comptable'=>$token,'id_foreign_type_categorie_plan_comptable'=>$id_type))->result_array();
        }

        function get_categorie_plan_comptable_by_id_type($id_type){
            return $this->db->get_where('categorie_plan_comptable',array('id_foreign_type_categorie_plan_comptable'=>$id_type))->result_array();
        }

        function get_categorie_plan_comptable_by_designation($token){
            return $this->db->get_where('categorie_plan_comptable',array('designation_categorie_plan_comptable'=>$token))->row_array();
        }

        function get_categorie_plan_comptable($id){
            return $this->db->get_where('categorie_plan_comptable',array('id_categorie_plan_comptable'=>$id))->row_array();
        }

        function get_categorie_plan_comptables_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }

        function delete_categorie_plan_comptable($token){
            $this->db->where("id_categorie_plan_comptable", $token);
            return $this->db->delete("categorie_plan_comptable");
        }

    }

?>