<?php

    class Caisse_model extends CI_Model{

        function add($params){
            $this->db->insert("caisse", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_caisse", $id);
            return $this->db->update("caisse", $params);
        }


        function update_by_state_devise_type($state,$devise,$type,$params){
            $this->db->where(["is_caisse_active"=>$state,'id_devise'=>$devise,'id_foreign_type_caisse'=>$type]);
            return $this->db->update("caisse", $params);
        }

        function get_all_caisses(){
            $this->db->order_by('id_caisse', 'desc');
            return $this->db->get('caisse')->result_array();
        }

        function get_caisse_by_id_entreprise($token){
            return $this->db->get_where('caisse',array('id_foreign_entreprise_salesienne'=>$token))->result_array();
        }

        function get_caisse_by_id_entreprise_greater_than_montant($id_entreprise,$montant_caisse){
            return  $this->db->query("SELECT * FROM caisse WHERE id_foreign_entreprise_salesienne =$id_entreprise AND montant_caisse >$montant_caisse")->result_array();;
        }

        function get_caisse_by_id($id){
            return $this->db->get_where('caisse',array('id_caisse'=>$id))->row_array();
        }

        function get_caisse_by_id_cdf_usd($id,$id_devise){
            return $this->db->get_where('caisse',array('id_caisse'=>$id,'id_devise'=>$id_devise))->row_array();
        }

        function get_caisse_by_id_cdf_usd_type_caisse($id,$id_devise,$id_type_caisse){
            return $this->db->get_where('caisse',array('id_caisse'=>$id,'id_devise'=>$id_devise,'id_foreign_type_caisse'=>$id_type_caisse))->row_array();
        }

        public function get_caisse_by_id_entreprise_id_devise_is_active_type_compte($id_entreprise,$id_devise,$is_active,$type_compte)
        {
            return $this->db->get_where('caisse',array('id_foreign_entreprise_salesienne'=>$id_entreprise,'id_devise'=>$id_devise,'is_caisse_active'=>$is_active,'id_foreign_type_caisse'=>$type_compte))->row_array();
        }


        function get_caisse_by_cdf_usd($id_devise){
            return $this->db->get_where('caisse',array('id_devise'=>$id_devise))->row_array();
        }

        function get_caisses_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }

        function delete_caisse($token){
            $this->db->where("id_caisse", $token);
            return $this->db->delete("caisse");
        }

    }

?>