<?php

    class Budget_entreprise_salesienne_model extends CI_Model{

        function add($params){
            $this->db->insert("budget_entreprise_salesienne", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_budget_entreprise_salesienne", $id);
            return $this->db->update("budget_entreprise_salesienne", $params);
        }



        function get_all_budget_entreprise_salesiennes(){
            $this->db->order_by('id_budget_entreprise_salesienne', 'desc');
            return $this->db->get('budget_entreprise_salesienne')->result_array();
        }

        function get_budget_entreprise_salesienne_by_id_entreprise($token){
            return $this->db->get_where('budget_entreprise_salesienne',array('id_foreign_budget_entreprise_salesienne'=>$token))->result_array();
        }

        function get_budget_entreprise_salesienne_by_id_entreprise_annee($token,$annee){
           $query = $this->db->query("SELECT * FROM budget_entreprise_salesienne WHERE id_foreign_budget_entreprise_salesienne =$token AND annee_exercice =$annee")->result_array();
           return $query;
        }

        function get_budget_entreprise_salesienne_by_annee($annee){
            $query = $this->db->query("SELECT * FROM budget_entreprise_salesienne WHERE annee_exercice =$annee")->result_array();
            return $query;
         }

        function get_budget_entreprise_salesienne($id){
            return $this->db->get_where('budget_entreprise_salesienne',array('id_budget_entreprise_salesienne'=>$id))->row_array();
        }

        function get_budget_entreprise_salesienne_by_annee_identreprise($annee,$id_entreprise){
            return $this->db->get_where('budget_entreprise_salesienne',array('annee_exercice'=>$annee,'id_foreign_budget_entreprise_salesienne'=>$id_entreprise))->result_array();
        }

        function get_budget_entreprise_salesiennes_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }

        function delete_budget_entreprise_salesienne($token){
            $this->db->where("id_budget_entreprise_salesienne", $token);
            return $this->db->delete("budget_entreprise_salesienne");
        }

    }

?>