<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Starter extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */


	public function index($error = '')
	{
		$this->load->view('login/index',['error'=>$error]);
	}

	function login($error = ''){
		$this->load->view('login/index',['error'=>$error]);
	}

	function check_connexion(){

		$this->form_validation->set_rules("email", "Adresse email", "required", array(
			"required" => "Veuillez saisir votre adresse email"
		));
		$this->form_validation->set_rules("password", "Mot de passe", "required", array(
			"required" => "Veuillez saisir votre mot de passe"
		));
		
		if($this->form_validation->run()){
			
			$user = $this->Utilisateur_model->check_connexion($this->security->xss_clean($this->input->post("email")));
			if(!empty($user)){
				if(password_verify($this->security->xss_clean($this->input->post("password")), $user['password'])){
					$role = $this->Role_model->get_role($user['id_role']);
					$_SESSION['user'] = $user;
					$_SESSION['role'] = $role;
					$_SESSION['logged_in'] = true;

					$action = [
						"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
						"nom_table"=> 'null',
						"id_champ"=> null,
						"action" => "connexion",
						"text_descriptif" => "connexion au systeme",
						'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
						"date_heure" => date("Y-m-d H:m:i")
					];
			
				
					$this->Action_utilisateur_model->add( $action );

					redirect("Budget/index/");
				} else {
					$this->login("L'adresse email ou le mot de passe est incorrect");
				}
			} else {
				$this->login("L'adresse email ou le mot de passe est incorrect");
			}
		} else {
			$this->login();
		}
	}

	public function disconnect(){
		
		if( isset( $_SESSION['user']['id_utilisateur'] ) ){
			$action = [
				"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
				"nom_table"=> 'null',
				"id_champ"=> null,
				"action" => "déconnexion",
				"text_descriptif" => "déconnexion du systeme",
				'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
				"date_heure" => date("Y-m-d H:m:i")
			];
			$this->Action_utilisateur_model->add( $action );
	
			session_destroy();
		}
		redirect('Starter/index');
	}

	public function invoice(){
		$header = $this->load->view("layouts/header", [], true);
		$sidebar = $this->load->view("layouts/sidebar", [], true);
		$navbar = $this->load->view("layouts/navbar", [], true);
		$footer = $this->load->view("layouts/footer", [], true);
		$this->load->view('facture/facture', ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer]);
	}

}
