<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Plan_comptable extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('plan_comptable', $this->session->user['id_role'], 'voir')){
				
				$crud = new grocery_CRUD();
				$settings_link_active = 'link_menu_active';

				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0){
					$crud->where(['id_foreign_entreprise_salesienne_plan_comptable'=>$_SESSION['user']['id_foreign_entreprise_salesienne']]);
				}

				$crud->set_table('plan_comptable');
				$crud->columns('id_plan_comptable','id_foreign_entreprise_salesienne_plan_comptable','code_du_programme','id_foreign_caisse','is_active');
				$crud->display_as('id_plan_comptable','#');
				$crud->display_as('id_foreign_entreprise_salesienne_plan_comptable','Oeuvre de Don Bosco');
				$crud->display_as('code_du_programme','Code du programme');
				$crud->display_as('id_foreign_caisse','N° DE CPTE');
				$crud->display_as('is_active','Etat');
				$crud->set_subject('Un Plan Comptable');
	
				$crud->callback_before_insert(array($this, '_onRowBeforeInserted'));
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_before_update(array($this,'_onRowBeforeUpdated'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
	
				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0 ){
					$crud->set_relation('id_foreign_caisse','caisse','{numero_caisse}',['id_foreign_type_caisse'=>2]);
					$crud->set_relation('id_foreign_entreprise_salesienne_plan_comptable','entreprise_salesienne', 'nom_entreprise_salesienne' );
				}else{
					$crud->set_relation('id_foreign_caisse','caisse','{numero_caisse}',['id_foreign_entreprise_salesienne'=>$_SESSION['user']['id_foreign_entreprise_salesienne'],'id_foreign_type_caisse'=>2]);
					$crud->field_type('id_foreign_entreprise_salesienne_plan_comptable','hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				}

				$crud->set_relation('is_active','is_active','designation');
				$crud->required_fields('id_foreign_entreprise_salesienne_plan_comptable','code_du_programme','id_foreign_caisse','is_active');
				$crud->unset_clone();
				$crud->callback_column('id_foreign_entreprise_salesienne_plan_comptable',array($this,'_callback_entreprise_salesienne'));
				$this->stateDisplay($crud);

				if( ! check_privilege('plan_comptable', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('plan_comptable', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('plan_comptable', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if(  check_privilege('plan_comptable', $this->session->user['id_role'], 'voir') ){
					$crud->add_action('Détails', '', '','list-alt',array($this,'show_plan_comptable_details'));
				}

				if( ! check_privilege('plan_comptable', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}


				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					// $crud->unset_add();
					// $crud->unset_read();
					// $crud->unset_delete();
					// $crud->unset_edit();
				}

				$crud->order_by('id_plan_comptable','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("plan_comptable/plan_comptable", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Un Plan Comptable ");
				break;
			case 'list':
				$crud->set_subject("Un Plan Comptable ");
				break;
			case 'add':
				$crud->set_subject("D'Un Plan Comptable ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Un Plan Comptable ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Plan Comptable',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'Un Plan Comptable ".$post_array["code_du_programme"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowBeforeUpdated($post_array, $primary_key){
		// if( (int) $post_array['is_active'] == 1){
		// 	$update_plan_comptable_state =[
		// 		'is_active' =>2
		// 	];
		// 	$this->Plan_comptable_model->update_active_state(1,$update_plan_comptable_state);
		// }
	}

	public function _onRowBeforeInserted($post_array){
		// if( (int) $post_array['is_active'] == 1){
		// 	$update_plan_comptable_state =[
		// 		'is_active' =>2
		// 	];
		// 	$this->Plan_comptable_model->update_active_state(1,$update_plan_comptable_state);
		// }
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Plan Comptable',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jourde du Plan Comptable ".$post_array["code_du_programme"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_plan_comptable'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Plan Comptable',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression du Plan Comptable ".$this->ModelGetTableRow->getObjectFieldValue($data,'plan_comptable')->code_du_programme,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return $entreprise_salesienne['nom_entreprise_salesienne'];
		}
	}

	public function afficherPlan($id_plan_comptbale=null, $annee_excerice =null, $id_user_entreprise=null)
	{

		if(  $this->session->logged_in ){
			$annee_excerice 						= (isset($_POST['annee_excerice'])) ? (int)$_POST['annee_excerice'] : (int) $annee_excerice;
			$id_user_entreprise 					= (int) $id_user_entreprise;
			$id_plan_comptbale 						= (int) $id_plan_comptbale;
			$plan_comptbale 						= $this->Plan_comptable_model->get_plan_comptable_by_is_active($id_plan_comptbale,1);
			$settings_link_active 					= 'link_menu_active';
			if( !empty($plan_comptbale) ){

				$entreprise_salesiennne 					= $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_user_entreprise);
				$caisse 									= $this->Caisse_model->get_caisse_by_id($plan_comptbale['id_foreign_caisse']);
				$sous_categorie_plan_comptables				= $this->Sous_categorie_model->get_sous_categorie_comptable_by_id_entreprise($id_user_entreprise);
				$categorie_sous_cat_plan_comptables_array 	= $this->_build_categorie_sous_cat_plan_comptable_array($sous_categorie_plan_comptables);

				$crud = new grocery_CRUD();
				$crud->set_table('sexe');
				$output = $crud->render();

				if((int) $plan_comptbale['is_active'] == 1){
					$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
					$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);
					$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
					$this->load->view("plan_comptable/afficher_plan_comptable", [
						'header'=>$header,
						'footer'=>$footer,
						'navbar'=>$navbar,
						'annee_excerice'=>$annee_excerice,
						'entreprise_salesiennne'=>$entreprise_salesiennne,
						'plan_comptbale'=>$plan_comptbale,
						'caisse'=>$caisse,
						'output'=>$output->output,
						'categorie_sous_cat_plan_comptables_array'=>$categorie_sous_cat_plan_comptables_array,
					]);	
				}else{
					redirect('Plan_comptable/index/');
				}
			}else{
				redirect('Plan_comptable/index/');
			}
		}else {
			redirect("Starter/login");
		}

	}

	public function show_plan_comptable_details($primary_key , $row)
	{
		$plan_comptbale = $this->Plan_comptable_model->get_plan_comptable($primary_key);
		return site_url('Plan_comptable/afficherPlan/').$primary_key.'/'.date('Y').'/'.$plan_comptbale['id_foreign_entreprise_salesienne_plan_comptable'];
	}

	public function _build_categorie_sous_cat_plan_comptable_array($sous_categorie_plan_comptables)
	{
		$categorie_sous_cat_comptables_results = [];
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			$categorie_plan_comptable =  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable($sous_categorie_plan_comptable['id_foreign_categorie_plan_comptable']);
			
			if(!empty($categorie_plan_comptable) ){

				if( (int) $categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] == 1){
					if( isset( $categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] ) ){
						$categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}else{
						$categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] = $categorie_plan_comptable;
						$categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}
				}else{
					if( isset( $categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] ) ){
						$categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}else{
						$categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] = $categorie_plan_comptable;
						$categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}
				}
			}
		}

		return $categorie_sous_cat_comptables_results;
	}
}
