<?php

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT");
defined('BASEPATH') OR exit('No direct script access allowed');

class Livre extends CI_Controller {

	public function index($id_type_compte_livre_caisse=null,$id_devise=null,$id_entreprise_salesienne=null,$periode_date=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('livre_caisse_banque', $this->session->user['id_role'], 'voir')){

				$crud 						= new grocery_CRUD();
				$livre_caisse_banques 		= $this->Livre_caisse_banque_model->get_all_livre_caisse_banques(); 
				$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes(); 
				$types_de_transactions 		= $this->Type_transaction_model->get_all_type_transactions();
				$type_categorie_accounting	= $this->buildForeignSousCategorieDropDown( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				$montant_caisse_cdf 		= 0;
				$montant_caisse_usd 		= 0;
				$id_tab_devise 				= ['1'=>'CDF','2'=>'USD','3'=>'EUR'];
				$caisse_entreprise 			= $this->Caisse_model->get_caisse_by_id_entreprise_id_devise_is_active_type_compte($id_entreprise_salesienne,$id_devise,1,$id_type_compte_livre_caisse);
				$caisses_entreprise 		= [];
				$montant_solde_caisse 		= 0;
				$livre_caisse_link_active   = '';
				$livre_banque_link_active   = '';
				$livre_menu_style 			= "padding-left: 10px;";
				$sql 						= '';
				$current_month 				= date("m");
				$current_year 				= date("Y");
				$array_prevent_periode 		= ['add','edit','view','read','upload_file','insert_validation','insert','delete','success'];
				$livre_caisse_banque_dropdown_cat_comptable = [];

				if(!!isset( $caisse_entreprise['montant_caisse'] ) ){
					$caisses_entreprise 		= $this->Caisse_model->get_caisse_by_id_entreprise_greater_than_montant($id_entreprise_salesienne,$caisse_entreprise['montant_caisse']);
				}

				if($id_type_compte_livre_caisse <>null AND $id_devise <>null){

					if( (int) $id_type_compte_livre_caisse == 1){
						$livre_caisse_link_active   = 'link_menu_active';
					}else{
						$livre_banque_link_active   = 'link_menu_active';
					}


					if($periode_date<>null AND !in_array($periode_date, $array_prevent_periode)){
						$sql = "id_foreign_type_compte_livre_caisse =$id_type_compte_livre_caisse AND id_foreign_devise =$id_devise";
						if( $periode_date == $current_month ){
							$sql.=" AND EXTRACT(YEAR FROM date_enregistrement_livre_caisse_banque)=$current_year AND EXTRACT(MONTH FROM date_enregistrement_livre_caisse_banque)=$periode_date";
							$periode_date = get_month_array()[$periode_date];
						}else{
							$sql.=" AND EXTRACT(YEAR FROM date_enregistrement_livre_caisse_banque)=$current_year AND EXTRACT(MONTH FROM date_enregistrement_livre_caisse_banque)<=$periode_date";
							$periode_date = ($periode_date == '03') ? 'TRIMESTRE '.$current_year : 'SEMESTRE '.$current_year;
						}
					}else{
						$periode_date = null;
					}
					
					if( !isset( $_POST['start_date'] )  AND !isset($_POST['end_date']) AND (!isset($periode_date) OR $periode_date == null)){
						$sql = "id_foreign_type_compte_livre_caisse =$id_type_compte_livre_caisse AND id_foreign_devise =$id_devise";
						$sql.=" AND EXTRACT(YEAR FROM date_enregistrement_livre_caisse_banque)=$current_year AND EXTRACT(MONTH FROM date_enregistrement_livre_caisse_banque)=$current_month";
					}
					
					if($id_entreprise_salesienne<>null AND $id_entreprise_salesienne <>0){
						$sql.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_SESSION['user']['id_foreign_entreprise_salesienne'];
					}
					
					$label_livre_caisse_banque = ($id_type_compte_livre_caisse == 1) ? "LIVRE DE CAISSE " : "LIVRE DE BANQUE ";
					$label_livre_caisse_banque .= $id_tab_devise[''.$id_devise]; 
					
					
					if( isset( $_POST['start_date'] )  AND isset($_POST['end_date'])){
	
						$sql ="date_enregistrement_livre_caisse_banque BETWEEN '".$_POST['start_date']."' AND '".$_POST['end_date']."'";
						$sql .=" AND id_foreign_type_compte_livre_caisse =$id_type_compte_livre_caisse AND id_foreign_devise =$id_devise";
						
						
						if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){
	
							if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
								$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							}else{
								$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
							}
						}else{
							$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}
	
						if(  isset( $_POST['id_foreign_categorie_comptable'] ) AND $_POST['id_foreign_categorie_comptable'] <> 'null'){
							$sql .=" AND id_foreign_categorie_comptable =".$_POST['id_foreign_categorie_comptable']."";
						}
	
						if( isset( $_POST['id_foreign_type_trx'] ) AND $_POST['id_foreign_type_trx'] <> 'null' ){
							$sql .=" AND id_foreign_type_trx =".$_POST['id_foreign_type_trx']."";
						}
						
					}

				}			

				
				$crud->where($sql);
				$livre_caisse_banques 	= $this->Livre_caisse_banque_model->get_livre_caisse_banques_by_query('SELECT * FROM livre_caisse_banque WHERE '.$sql);
				$entreprise_salesienne 	= $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne); 

				$total_entree 			= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,1,false);
				$total_entree_usd 		= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,1,true);
				$total_sortie 			= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,2,false);
				$total_sortie_usd 		= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,2,true);
				$montant_solde_caisse 	= (count($livre_caisse_banques)>0) ? $livre_caisse_banques[ (count($livre_caisse_banques)-1) ] ['solde_restant_caissse'] : 0;

				$crud->set_table('livre_caisse_banque');
				$crud->columns('id_livre_caisse_banque','id_foreign_categorie_comptable','taux','montant_livre_caisse_banque','montant_livre_caisse_banque_converti','description','id_foreign_caisse','id_foreign_type_trx','id_foreign_type_compte_livre_caisse','file_preuve','id_foreign_entreprise_salesienne_livre_caisse_banque','date_enregistrement_livre_caisse_banque');
				$crud->display_as('id_livre_caisse_banque','#');
				$crud->display_as('id_foreign_categorie_comptable','Catégorie Comptable ');
				$crud->display_as('taux','Taux');
				$crud->display_as('montant_livre_caisse_banque','Montant');
				$crud->display_as('montant_livre_caisse_banque_converti','Montant Converti USD');
				$crud->display_as('id_foreign_caisse','Caisse');
				$crud->display_as('file_preuve','Fichier de Preuve');
				$crud->display_as('id_foreign_type_trx','Type de Transaction');
				$crud->display_as('id_foreign_type_compte_livre_caisse','Type de Compte');
				$crud->display_as('id_foreign_devise','Devise');
				$crud->display_as('description','Description');
				$crud->display_as('solde_restant_caissse','Solde Restant Caisse');
				$crud->display_as('id_foreign_entreprise_salesienne_livre_caisse_banque','Oeuvre de Don Bosco');
				$crud->display_as('date_enregistrement_livre_caisse_banque','Date d\'enregistrement');
				$crud->set_subject('Une entrée de '.strtolower($label_livre_caisse_banque));
	
				$crud->callback_before_insert(array($this, '_onRowBeforeInserted'));
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));

				$montant_caisse_cdf 		= 0;
				$montant_caisse_usd 		= 0;
				$livre_caisse_banque_dropdown_cat_comptable	= $this->buildForeignSousCategorieDropDown( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] );
			
				$crud->set_relation('id_foreign_caisse','caisse','numero_caisse', ['id_foreign_entreprise_salesienne' =>(int) $_SESSION['user']['id_foreign_entreprise_salesienne'],'id_devise'=>(int) $id_devise,'is_caisse_active'=>1,'id_foreign_type_caisse'=>(int) $id_type_compte_livre_caisse] );
				$crud->set_relation('id_foreign_type_trx','type_transaction','designation');
				$crud->set_field_upload('file_preuve','assets/uploads/files');
				$crud->field_type('id_foreign_devise', 'hidden');
				$crud->field_type('montant_livre_caisse_banque_converti', 'hidden');
				$crud->field_type('solde_restant_caissse', 'hidden');
				$crud->field_type('id_foreign_entreprise_salesienne_livre_caisse_banque', 'hidden', (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				$crud->field_type('id_foreign_type_compte_livre_caisse','hidden',(int) $id_type_compte_livre_caisse);
				$crud->required_fields('id_livre_caisse_banque','id_foreign_categorie_comptable','taux','montant_livre_caisse_banque','id_foreign_caisse','id_foreign_type_trx','id_foreign_type_compte_livre_caisse','file_preuve','date_enregistrement_livre_caisse_banque','description');

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0 ){
					$crud->field_type('id_foreign_categorie_comptable','dropdown',$livre_caisse_banque_dropdown_cat_comptable);
				}

				$crud->callback_column('id_foreign_entreprise_salesienne_livre_caisse_banque',array($this,'_callback_entreprise_salesienne'));
				$crud->callback_column('id_foreign_type_compte_livre_caisse',array($this,'_callback_type_compte_livre_caisse'));
				$crud->callback_column('montant_livre_caisse_banque_converti',array($this,'_callback_montant_livre_caisse_banque_converti'));
				$crud->callback_column('montant_livre_caisse_banque',array($this,'_callback_montant_livre_caisse_banque'));
				$crud->callback_read_field('id_foreign_categorie_comptable',array($this,'_callback_read_categorie_comptable'));

				$crud->unset_clone();
				$crud->unset_edit();

				if((int) $id_devise == 2){
					$crud->field_type('taux','hidden',1);
				}

				$this->stateDisplay($crud, strtolower($label_livre_caisse_banque));

				if( ! check_privilege('livre_caisse_banque', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('livre_caisse_banque', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('livre_caisse_banque', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					$crud->unset_add();
					$crud->unset_read();
					$crud->unset_delete();
				}

				$crud->order_by('id_livre_caisse_banque','desc');
	
				$output = $crud->render();

				
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['livre_caisse_link_active'=>$livre_caisse_link_active,'livre_banque_link_active'=>$livre_banque_link_active,'livre_menu_style'=>$livre_menu_style], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("livre_caisse_banque/livre_caisse_banque", [
					'header' => $header, 
					'navbar'=>$navbar, 
					'sidebar' => $sidebar, 
					'footer' => $footer,
					'output'=>$output->output,
					'livre_caisse_banques'=>$livre_caisse_banques,
					'entreprise_salesiennes'=>$entreprise_salesiennes,
					'entreprise_salesienne'=>$entreprise_salesienne,
					'montant_caisse_cdf'=>$montant_caisse_cdf,
					'montant_caisse_usd'=>$montant_caisse_usd,
					'types_de_transactions'=>$types_de_transactions,
					'type_categorie_accounting'=>$type_categorie_accounting,
					'label_livre_caisse_banque'=>$label_livre_caisse_banque,
					'label_devise'=>$id_tab_devise[''.$id_devise],
					'caisse_entreprise'=>$caisse_entreprise,
					'montant_solde_caisse'=>$montant_solde_caisse,
					'total_entree'=>$total_entree,
					'total_entree_usd'=>$total_entree_usd,
					'total_sortie'=>$total_sortie,
					'total_sortie_usd'=>$total_sortie_usd,
					'id_entreprise_salesienne'=>$id_entreprise_salesienne,
					'id_type_compte_livre_caisse'=>$id_type_compte_livre_caisse,
					'id_devise'=>$id_devise,
					'periode_date'=>$periode_date,
					'caisses_entreprise'=>$caisses_entreprise,
				]);	
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud, $label =null){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une entrée de ".$label);
				break;
			case 'list':
				$crud->set_subject("Une entrée de ".$label);
				break;
			case 'add':
				$crud->set_subject("Une entrée de ".$label);
				break;
			
			case 'edit':
				$crud->set_subject("Une entrée de ".$label);
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{  
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _callback_read_categorie_comptable($value, $primary_key)
	{
		$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable( (int) $value );
		if(!empty( $sous_categorie) ){
				return $sous_categorie['code_comptable']." - ".$sous_categorie['designation_sous_categorie_plan_comptable'];
		}
		return $value;
	}

	public function _onRowBeforeInserted($post_array)
	{
		$caisse = $this->Caisse_model->get_caisse_by_id((int) $post_array['id_foreign_caisse']);

		if(!empty($caisse)){
			$post_array['id_foreign_devise'] = $caisse['id_devise'];
		}
		$post_array['montant_livre_caisse_banque_converti'] =  ( $post_array['montant_livre_caisse_banque'] / $post_array['taux']);

		return $post_array;
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		$caisse 		= $this->Caisse_model->get_caisse_by_id((int) $post_array['id_foreign_caisse']);
		$sous_categorie_comptable = $this->Sous_categorie_model->get_sous_categorie_comptable($post_array['id_foreign_categorie_comptable']);
		
		if(!empty($caisse)){
			$montant_caisse = ( (int) $post_array['id_foreign_type_trx'] == 1 ) ?  $caisse['montant_caisse'] +  $post_array['montant_livre_caisse_banque'] :  $caisse['montant_caisse'] -  $post_array['montant_livre_caisse_banque'];
			
			$caisse_update_montant = [
				'montant_caisse' => $montant_caisse,
			];
			$this->Caisse_model->update($caisse['id_caisse'],$caisse_update_montant);

			$livre_caisse_banque_update_solde_restant =[
				'solde_restant_caissse'=> $montant_caisse
			];

			$this->Livre_caisse_banque_model->update($primary_key,$livre_caisse_banque_update_solde_restant);

			if(!empty($sous_categorie_comptable)){

				if( ( (int) $sous_categorie_comptable['code_comptable'] == 5200  OR  (int) $sous_categorie_comptable['code_comptable'] == 5299 )
					AND
					(int) $post_array['id_foreign_type_trx'] == 2
					AND
					(int) $caisse['id_foreign_type_caisse'] = 1
				  )
				{

					$caisse_banque = $this->Caisse_model->get_caisse_by_id_entreprise_id_devise_is_active_type_compte( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'],(int) $caisse['id_devise'], 1,2);
					if(!empty($caisse_banque)){
						$caisse_update_montant_banque = [
							'montant_caisse' => $caisse_banque['montant_caisse']  + $post_array['montant_livre_caisse_banque'],
						];
						$this->Caisse_model->update($caisse_banque['id_caisse'],$caisse_update_montant_banque);
					}

				}


				if( ( (int) $sous_categorie_comptable['code_comptable'] == 5700 OR (int) $sous_categorie_comptable['code_comptable'] == 5799) 
					AND
					(int) $post_array['id_foreign_type_trx'] == 2
					AND
					(int) $caisse['id_foreign_type_caisse'] = 2
				  )
				{

					$caisse_locale = $this->Caisse_model->get_caisse_by_id_entreprise_id_devise_is_active_type_compte( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'],(int) $caisse['id_devise'], 1,1);
					if(!empty($caisse_locale)){
						$caisse_update_montant_caisse_locale = [
							'montant_caisse' => $caisse_locale['montant_caisse']  + $post_array['montant_livre_caisse_banque'],
						];
						$this->Caisse_model->update($caisse_locale['id_caisse'],$caisse_update_montant_caisse_locale);
					}

				}

			}
		}	
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Livre caisse banque',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'une entrée de livre de caisse banque ID = ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}


	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Livre caisse banque',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour d'une entrée de livre de caisse banque ID =  ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Livre caisse banque',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression de l'entrée de livre de caisse banque  ID = ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );

		$livre_caisse_banque = $this->Livre_caisse_banque_model->get_livre_caisse_banque($primary_key);

		if(!empty($livre_caisse_banque) ){
			$caisse = $this->Caisse_model->get_caisse_by_id((int) $livre_caisse_banque['id_foreign_caisse']);

			if(!empty($caisse)){
				$montant_caisse = ( (int) $livre_caisse_banque['id_foreign_type_trx'] == 1 ) ? $caisse['montant_caisse'] -  $livre_caisse_banque['montant_livre_caisse_banque'] :  $caisse['montant_caisse'] + $livre_caisse_banque['montant_livre_caisse_banque'];
				
				$caisse_update_montant = [
					'montant_caisse' => $montant_caisse,
				];
				$this->Caisse_model->update($caisse['id_caisse'],$caisse_update_montant);

				$last_livre_caisse_banque_row  = $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row();
				
				$livre_caisse_banque_update_solde_restant =[
					'solde_restant_caissse'=> $montant_caisse
				];
	
				$this->Livre_caisse_banque_model->update($last_livre_caisse_banque_row['id_livre_caisse_banque'],$livre_caisse_banque_update_solde_restant);
			}	
		}
		
		return true;
	}

	function calculateSommeUsdCdfEur($livre_caisse_banques,$usd_cdf_eur, $type_trx,$bool_conversion ){
		$montant_usd_cdf_eur = 0;
		foreach ($livre_caisse_banques as $key => $livre_caisse_banque) {
			if($bool_conversion == true){
				if( ((int) $livre_caisse_banque['id_foreign_devise'] == (int) $usd_cdf_eur ) AND ((int) $livre_caisse_banque['id_foreign_type_trx'] == (int) $type_trx) ){
					$montant_usd_cdf_eur = $montant_usd_cdf_eur + $livre_caisse_banque['montant_livre_caisse_banque_converti'];
				}
			}else{
				if(  ((int) $livre_caisse_banque['id_foreign_devise'] == (int) $usd_cdf_eur ) AND ((int) $livre_caisse_banque['id_foreign_type_trx'] == (int) $type_trx) ){
					$montant_usd_cdf_eur = $montant_usd_cdf_eur + $livre_caisse_banque['montant_livre_caisse_banque'];
				}
			}
		}
		return $montant_usd_cdf_eur;
	}

	public function buildForeignSousCategorieDropDown($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		
		if((int) $id_user_entreprise  ==  0){
			$sous_categorie_affectees = $this->Sous_categorie_affectee_model->get_all_sous_categorie_comptable_affectees();
		}

		$ids_sous_categorie_affectees 	= [];
		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees = explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$categorie_comptable =  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable( $sous_categorie['id_foreign_categorie_plan_comptable']);
						if(!empty($categorie_comptable)){
							$sous_categorie_affectee_result[ $sous_categorie['id_sous_categorie_comptable'] ] =$sous_categorie['code_comptable']." - ".$sous_categorie['designation_sous_categorie_plan_comptable'];							
						}
					}
				}
			}
		}
		return $sous_categorie_affectee_result;
	}


	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return $entreprise_salesienne['nom_entreprise_salesienne'];
		}
	}


	public function _callback_type_compte_livre_caisse($value, $row){
		$type_compre_livre_caisse = $this->Type_compte_livre_caisse_banque_model->get_type_compte_livre_caisse($value);
		if(!empty($type_compre_livre_caisse)){
			return $type_compre_livre_caisse['designation'];
		}
	}

	public function _callback_montant_livre_caisse_banque($value, $row){
		
		return number_format($value,2);
	}

	public function _callback_montant_livre_caisse_banque_converti($value, $row){
		
		return number_format($value,2);
	}
	
	public function afficherLivre($id_type_compte_livre_caisse=null, $id_devise =null, $id_user_entreprise=null,$start_date=null,$end_date=null)
	{
		if(  $this->session->logged_in ){

			$id_tab_devise 				= ['1'=>'CDF','2'=>'USD','3'=>'EUR'];
			$annee 						= date('Y');
			$current_month 				= date("m");
			$current_year 				= date("Y");
			$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes(); 
			$start_date 				= (isset($_POST['start_date'])) ? $_POST['start_date'] : $start_date;
			$end_date 					= (isset($_POST['end_date'])) ? $_POST['end_date'] : $end_date;
			$id_user_entreprise 		= ( isset($_POST['id_entreprise_salesienne']) ) ? $_POST['id_entreprise_salesienne'] : $id_user_entreprise; 

			if($start_date <> null AND $end_date<> null){
				$_POST['start_date'] 	= $start_date;
				$_POST['end_date']		= $end_date;
			}


			if($id_type_compte_livre_caisse <>null AND $id_devise <>null AND $id_user_entreprise <> null){

				$entreprise_salesienne 		= $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_user_entreprise); 
				$caisse_entreprise 			= $this->Caisse_model->get_caisse_by_id_entreprise_id_devise_is_active_type_compte($id_user_entreprise,$id_devise,1,$id_type_compte_livre_caisse);
				$label_livre_caisse_banque 	= ($id_type_compte_livre_caisse == 1) ? "LIVRE DE CAISSE " : "LIVRE DE BANQUE ";
				$label_livre_caisse_banque 	.= $id_tab_devise[''.$id_devise]; 

				$sql = " id_foreign_type_compte_livre_caisse =$id_type_compte_livre_caisse AND id_foreign_devise =$id_devise";
				$sql.= " AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$id_user_entreprise;

				if( ($start_date <> null AND $end_date <> null) OR (strlen($start_date)>2 AND strlen($end_date) >2 )  ){
					$sql .=" AND date_enregistrement_livre_caisse_banque BETWEEN '".$start_date."' AND '".$end_date."'";
					$annee =  explode('-',$end_date);
					$annee = $annee[0];
				}else{
					$sql.=" AND EXTRACT(YEAR FROM date_enregistrement_livre_caisse_banque)=$current_year AND EXTRACT(MONTH FROM date_enregistrement_livre_caisse_banque)=$current_month";
				}

				


				$sql					.=' ORDER BY id_livre_caisse_banque ASC';
				$livre_caisse_banques 	 = $this->Livre_caisse_banque_model->get_livre_caisse_banques_by_query('SELECT * FROM livre_caisse_banque WHERE '.$sql);
				
				foreach ($livre_caisse_banques as $key => $livre_caisse_banque) {
					$categorie_comptable = $this->Sous_categorie_model->get_sous_categorie_comptable($livre_caisse_banque['id_foreign_categorie_comptable']);
					if(!empty($categorie_comptable)){
						$livre_caisse_banque['id_foreign_categorie_comptable'] = $categorie_comptable['designation_sous_categorie_plan_comptable'];
						$livre_caisse_banque['code'] = $categorie_comptable['code_comptable'];
					}
					$livre_caisse_banques[$key] =  $livre_caisse_banque;
				}

				$total_entree 		= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,1,false);
				$total_sortie 		= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,2,false);
				$total_entree_usd 	= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,1,true);
				$total_sortie_usd 	= $this->calculateSommeUsdCdfEur($livre_caisse_banques,$id_devise,2,true);

			}

			$montant_solde_caisse 	= (count($livre_caisse_banques)>0) ? $livre_caisse_banques[ count($livre_caisse_banques)-1 ] ['solde_restant_caissse'] : 0;
			$crud = new grocery_CRUD();
			$crud->set_table('sexe');
			$output = $crud->render();

			$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
			$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
			
			$this->load->view("livre_caisse_banque/afficher_livre_caisse_banque", [
				'header'=>$header,
				'footer'=>$footer,
				'entreprise_salesienne'=>$entreprise_salesienne,
				'caisse_entreprise'=>$caisse_entreprise,
				'montant_solde_caisse'=>$montant_solde_caisse,
				'label_livre_caisse_banque'=>$label_livre_caisse_banque,
				'id_type_compte_livre_caisse'=>$id_type_compte_livre_caisse,
				'id_devise'=>$id_devise,
				'id_user_entreprise'=>$id_user_entreprise,
				'entreprise_salesiennes'=>$entreprise_salesiennes,
				'livre_caisse_banques'=>$livre_caisse_banques,
				'start_date'=>$start_date,
				'end_date'=>$end_date,
				'annee'=>$annee,
				'total_entree'=>$total_entree,
				'total_sortie'=>$total_sortie,
				'total_entree_usd'=>$total_entree_usd,
				'total_sortie_usd'=>$total_sortie_usd,
				'label_devise'=>$id_tab_devise[$id_devise],
				'output'=>$output->output,
			]);	
		}else {
			redirect("Starter/login");
		}	

	}

	public function verifySoldeCaisse()
	{
		echo 'ready';
	}

	
}
