<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Entreprise_salesienne extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('entreprise_salesienne', $this->session->user['id_role'], 'voir')){


				$crud = new grocery_CRUD();
				$settings_link_active = 'link_menu_active';

				$crud->where(['id_entreprise_salesienne!='=>32]);

				if( isset( $_POST['start_date'] )  AND isset($_POST['end_date'])){
					$sql =" date_enregistrement_entreprise_salesienne BETWEEN '".$_POST['start_date']."' AND '".$_POST['end_date']."'";					
					$crud->where($sql);
				}


				$crud->set_table('entreprise_salesienne');
				$crud->columns('id_entreprise_salesienne','nom_entreprise_salesienne','logo_entreprise_salesienne','tel_entreprise_salesienne','id_foreign_type_entreprise_salesienne','adresse_entreprise_salesienne','date_enregistrement_entreprise_salesienne');
				$crud->display_as('id_entreprise_salesienne','#');
				$crud->display_as('nom_entreprise_salesienne','Nom');
				$crud->display_as('logo_entreprise_salesienne','logo ');
				$crud->display_as('tel_entreprise_salesienne','Téléphone de contact');
				$crud->display_as('adresse_entreprise_salesienne','Adresse ');
				$crud->display_as('id_foreign_type_entreprise_salesienne','Type ');
				$crud->display_as('date_enregistrement_entreprise_salesienne','Date d\'enregistrement ');
				$crud->set_subject('Une Oeuvre de Don Bosco');
	
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
	
				$crud->set_relation('id_foreign_type_entreprise_salesienne','type_entreprise_salesienne','designation');

				$crud->required_fields('nom_entreprise_salesienne','tel_entreprise_salesienne','id_foreign_type_entreprise_salesienne');
				$crud->unique_fields(array('tel_entreprise_salesienne'));
				$crud->unset_clone();
				$crud->set_field_upload('logo_entreprise_salesienne','assets/uploads/files');
				$crud->field_type('date_enregistrement_entreprise_salesienne', 'hidden',date('Y-m-d'));
				$this->stateDisplay($crud);

				if( ! check_privilege('entreprise_salesienne', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('entreprise_salesienne', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('entreprise_salesienne', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('entreprise_salesienne', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				$crud->order_by('id_entreprise_salesienne','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("entreprise_salesienne/entreprise_salesienne", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->callback_field('logo_entreprise_salesienne',array($this,'_showImage'));
				$crud->set_subject("Une Oeuvre de Don Bosco ");
				break;
			case 'list':
				$crud->set_subject("Une Oeuvre de Don Bosco ");
				$crud->callback_field('logo_entreprise_salesienne',array($this,'_showImage'));
				break;
			case 'add':
				$crud->set_subject("D'Une Oeuvre de Don Bosco ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Une Oeuvre de Don Bosco ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Entreprise Salesienne',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout de l'entreprise salesienne ".$post_array["nom_entreprise_salesienne"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Entreprise Salesienne',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jourde l'entreprise salesienne ".$post_array["nom_entreprise_salesienne"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_entreprise_salesienne'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Entreprise Salesienne',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression de l'entreprise salesienne ".$this->ModelGetTableRow->getObjectFieldValue($data,'entreprise_salesienne')->nom_entreprise_salesienne,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	
	
}
