<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Conf_pourcentage_bureau extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){

			if(check_privilege('conf_bureau', $this->session->user['id_role'], 'voir')){

				$crud = new grocery_CRUD();

				$crud->set_table('conf_pourcentage_bureau');
				$crud->columns('id_conf_pourcentage_bureau','nom_table','taux_pourcentage');
				$crud->display_as('id_conf_pourcentage_bureau','ID');
				$crud->display_as('nom_table','Sur les :');
				$crud->display_as('taux_pourcentage','Pourcentage du bureau %');
				
				
				$crud->set_subject('Un pourcentage de gain pour le bureau');

				$crud->add_fields(array('nom_table','taux_pourcentage'));
				$crud->edit_fields(array('nom_table','taux_pourcentage'));
				
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));



				$crud->required_fields('nom_table','taux_pourcentage');
				$crud->unset_clone();
				$crud->unset_delete();
				$this->stateDisplay($crud);

				if( ! check_privilege('conf_bureau', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('conf_bureau', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('conf_bureau', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('conf_bureau', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				$crud->order_by('id_conf_pourcentage_bureau','desc');

				$output = $crud->render();

				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/navbar", [], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("conf_pourcentage_bureau/conf_pourcentage_bureau", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}
			
		}else {
			redirect("Starter/login");
		}
	
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Un pourcentage de gain pour le bureau ");
				break;
			case 'list':
				$crud->set_subject("Un pourcentage de gain pour le bureau ");
				break;
			case 'add':
				$crud->set_subject("D'Un pourcentage de gain pour le bureau ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Un pourcentage de gain pour le bureau ");
				break;
			
			default:
				break;
		}

	}






	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'conf_pourcentage_bureau',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'une configuration de pourcentage de gain pour le bureau pour ".$post_array["nomTable"],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'conf_pourcentage_bureau',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour d' une configuration de pourcentage de gain pour le bureau pour ".$post_array["nomTable"],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_conf_pourcentage_bureau'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'conf_pourcentage_bureau',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "suppression d'une configuration de pourcentage de gain pour le bureau pour ".$this->ModelGetTableRow->getObjectFieldValue($data,'conf_pourcentage_bureau')->nom_table,
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	
}
