<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT");

defined('BASEPATH') OR exit('No direct script access allowed');

class Compte_resultat extends CI_Controller {

	public function index($id_year=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('compte_resultat', $this->session->user['id_role'], 'voir')){


				$entreprise_salesiennes 		= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes();
				$entreprise_salesienne      	= [];
				$id_entreprise_salesienne 		= (int) $_SESSION['user']['id_foreign_entreprise_salesienne'];
				$sous_comptable_affectee 		= null;
				$current_month_date 			= "";
				$next_month_date 				= "";
				$current_year_date 				= "";
				$next_year_date 				= "";
				$annee_excerice 				= null;
				$annee_excerice_next			= null;
				$compte_resultat_link_active	= 'link_menu_active';
				$balance_livre_caisse_banques 	= null;


				if( isset( $_POST['annee_exercice'] ) OR ( isset($id_year) ) ){

					$annee_excerice 	 	=  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$annee_excerice_next 	=  (int) $annee_excerice + 1;
					$start_date 			=  $annee_excerice.'/09/01';
					$end_date   			= ((int)$annee_excerice+1).'/08/31';
					$sql 					=" date_enregistrement_livre_caisse_banque BETWEEN '".$start_date."' AND '".$end_date."'";
									
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0 ){
							$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
							}
						}

					}else{
						$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}

					

					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] == 'situation de la province'){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
						$entreprise_salesienne['id_entreprise_salesienne'] = 'situation de la province';
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
					}else{
						$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$balance_livre_caisse_banques 	= $this->_build_categorie_sous_cat_plan_comptable_array($sous_comptable_affectee,$sql);	
					

				}else{
					redirect($_SERVER['HTTP_REFERER']);
				}
				
				$crud = new grocery_CRUD();
				$crud->set_table('livre_caisse_banque');
				$output = $crud->render();

				$header 	= $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar 	= $this->load->view("layouts/sidebar", [], true);
				$navbar 	= $this->load->view("layouts/menu_nav_bar", ['compte_resultat_link_active'=>$compte_resultat_link_active], true);
				$footer 	= $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$b_header 	= $this->load->view("balance/balance_header", [], true);
				$b_footer 	= $this->load->view("balance/balance_footer", [], true);

				$this->load->view("compte_resultat/compte_resultat", [
					'header' 	=> 	$header, 
					'navbar'	=>	$navbar, 
					'sidebar' 	=> 	$sidebar, 
					'footer' 	=> 	$footer,
					'b_header' 	=> 	$b_header,
					'b_footer' 	=> 	$b_footer,
					'annee_excerice' 	=> 	$annee_excerice,
					'annee_excerice_next' 	=> 	$annee_excerice_next,
					'current_year_date' 	=> 	$current_year_date,
					'next_year_date' 	=> 	$next_year_date,
					'current_month_date' 	=> 	$current_month_date,
					'next_month_date' 	=> 	$next_month_date,
					'output'=>$output->output,
					'oeuvre_don_bosco' 		=> 	$entreprise_salesienne,
					'entreprise_salesiennes' 		=> 	$entreprise_salesiennes,
					'balance_livre_caisse_banques' 	=> 	$balance_livre_caisse_banques,
				]);
		
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}

	public function export_complet ($id_year=null,$id_entreprise_salesienne_in=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('compte_resultat', $this->session->user['id_role'], 'voir')){

				$entreprise_salesienne      	= [];
				$id_entreprise_salesienne 		= ((int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0) ? 'situation de la province' : (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] ;
				$sous_comptable_affectee 		= null;
				$annee_excerice 				= null;
				$balance_livre_caisse_banques 	= null;
				$total_solde_debiteur           = 0;
				$total_solde_crediteur   		= 0;


				if($id_entreprise_salesienne_in<>null){
					$_POST['id_entreprise_salesienne'] = urldecode($id_entreprise_salesienne_in);
				}

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0  AND !isset($_POST['id_entreprise_salesienne']) ){
					$_POST['id_entreprise_salesienne'] = $id_entreprise_salesienne;
				}
				

				if( (isset( $_POST['annee_exercice'] ) OR ( isset($id_year) ) ) AND ( isset($id_entreprise_salesienne_in)) AND !empty($id_entreprise_salesienne_in) ){

					$annee_excerice 	 	=  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$annee_excerice_next 	=  (int) $annee_excerice + 1;
					$start_date 			=  $annee_excerice.'/09/01';
					$end_date   			= ((int)$annee_excerice+1).'/08/31';
					$sql 					= "date_enregistrement_livre_caisse_banque BETWEEN '".$start_date."' AND '".$end_date."'";
									
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0 ){
							$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
							}
						}

					}else{
						$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] == 'situation de la province'){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
					}else{
						$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$balance_livre_caisse_banques 	= $this->_build_categorie_sous_cat_plan_comptable_array($sous_comptable_affectee,$sql);	
					$file_export_name 			 	= 'Compte de résultat '.$entreprise_salesienne['nom_entreprise_salesienne'].' exercice '.$annee_excerice.'.pdf';
					$index_for_group_1 			 	= ( count($balance_livre_caisse_banques ['RECETTES']) >= count($balance_livre_caisse_banques ['DEPENSES']) ) ? count($balance_livre_caisse_banques ['RECETTES']) : count($balance_livre_caisse_banques ['DEPENSES']); 

					$pdf = new FPDF('L','cm','A4');

					$pdf->AddPage();
					$pdf->SetAutoPageBreak(true,2);

					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','','14');

					$pdf->Cell(27.8,1.5,iconv('UTF-8','windows-1252', strtoupper( 'COMPTE DE RESULTAT '.$entreprise_salesienne['nom_entreprise_salesienne'].' exercice '.$annee_excerice )),'',1,'L');
					$pdf->Image(base_url('assets/dore_assets').'/img/logo_salesien_bg.png',25,0.1,2.5,2.5);

					$pdf->SetFillColor(0,32,96);
					$pdf->SetTextColor(255,255,255);
					$pdf->SetFont('Times','','12');

					$pdf->Cell(13.9,1.5,'CHARGES','LTB',0,'C',true);
					$pdf->Cell(13.9,1.5,'PRODUITS','TRB',1,'C',true);

					$pdf->SetTextColor(0,0,0);
					$pdf->SetFont('Times','','11');
					$pdf->Cell(4.63,1,'CODE COMPTABLE','LBR',0,'C');
					$pdf->Cell(4.63,1,'DESIGNATION','BR',0,'C');
					$pdf->Cell(4.63,1,'VALEURS NETTE $','BR',0,'C');
					$pdf->Cell(4.63,1,'CODE COMPTABLE','LBR',0,'C');
					$pdf->Cell(4.63,1,'DESIGNATION','BR',0,'C');
					$pdf->Cell(4.63,1,'VALEURS NETTE $','BR',0,'C');
					$pdf->Ln();


					for ($i=0; $i < $index_for_group_1 ; $i++) { 

						if(isset($balance_livre_caisse_banques['DEPENSES'][$i])){
							$pdf->Cell(4.63,1,$balance_livre_caisse_banques['DEPENSES'][$i]['code_comptable'],'LBRT',0,'C');
							$pdf->Cell(4.63,1,ellipsis(iconv('UTF-8','windows-1252',$balance_livre_caisse_banques['DEPENSES'][$i]['designation_sous_categorie_plan_comptable']),26),'LBRT',0,'C');
							$pdf->Cell(4.63,1,number_format($balance_livre_caisse_banques['DEPENSES'][$i]['solde_debiteur'],2),'LBRT',0,'C');
							$total_solde_debiteur = $total_solde_debiteur + $balance_livre_caisse_banques['DEPENSES'][$i]['solde_debiteur'];
						}else{
							$pdf->Cell(4.63,1,'','LBRT',0,'C');
							$pdf->Cell(4.63,1,'','LBRT',0,'C');
							$pdf->Cell(4.63,1,'','LBRT',0,'C');
						}

						if(isset($balance_livre_caisse_banques ['RECETTES'][$i])){
							$pdf->Cell(4.63,1,$balance_livre_caisse_banques ['RECETTES'][$i]['code_comptable'],'LBRT',0,'C');
							$pdf->Cell(4.63,1,ellipsis( iconv('UTF-8','windows-1252',$balance_livre_caisse_banques ['RECETTES'][$i]['designation_sous_categorie_plan_comptable']),26),'BRT',0,'C');
							$pdf->Cell(4.63,1,number_format($balance_livre_caisse_banques ['RECETTES'][$i]['solde_crebiteur'],2),'BRT',0,'C');
							$total_solde_crediteur = $total_solde_crediteur + $balance_livre_caisse_banques ['RECETTES'][$i]['solde_crebiteur'];

						}else{
							$pdf->Cell(4.63,1,'','LBRT',0,'C');
							$pdf->Cell(4.63,1,'','BRT',0,'C');
							$pdf->Cell(4.63,1,'','BRT',0,'C');
						}

						$pdf->Ln();
					}

					$pdf->SetFillColor(166,166,166);
					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','B','12');

					$pdf->Cell(9,1,'TOTAL CHARGES','LBT',0,'L');
					$pdf->Cell(4.89,1,number_format($total_solde_debiteur,2).' $','BRT',0,'C');

					$pdf->Cell(9,1,'TOTAL PRODUITS','LBT',0,'L');
					$pdf->Cell(4.89,1,number_format($total_solde_crediteur,2).' $','BRT',0,'C');
					$pdf->Ln();


					$pdf->SetFillColor(0,32,96);
					$pdf->SetTextColor(255,255,255);
					$pdf->SetFont('Times','B','12');

					$pdf->Cell(13.89,1,'RESULTAT NET L\'EXERCICE ','LBT',0,'L',true);
					$pdf->Cell(13.89,1,number_format(  ($total_solde_crediteur - $total_solde_debiteur) ,2).' $','BRT',0,'R', true);

									
					$pdf->Output('D',$file_export_name);
				
				}else{
					redirect($_SERVER['HTTP_REFERER']);
				}
				
		
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}


	public function export_simple ($id_year=null,$id_entreprise_salesienne_in=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('compte_resultat', $this->session->user['id_role'], 'voir')){

				$entreprise_salesienne      	= [];
				$id_entreprise_salesienne 		= ((int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0) ? 'situation de la province' : (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] ;
				$sous_comptable_affectee 		= null;
				$annee_excerice 				= null;
				$balance_livre_caisse_banques 	= null;
				$total_solde_debiteur           = 0;
				$total_solde_crediteur   		= 0;


				if($id_entreprise_salesienne_in<>null){
					$_POST['id_entreprise_salesienne'] = urldecode($id_entreprise_salesienne_in);
				}

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0  AND !isset($_POST['id_entreprise_salesienne']) ){
					$_POST['id_entreprise_salesienne'] = $id_entreprise_salesienne;
				}
				

				if( (isset( $_POST['annee_exercice'] ) OR ( isset($id_year) ) ) AND ( isset($id_entreprise_salesienne_in)) AND !empty($id_entreprise_salesienne_in) ){

					$annee_excerice 	 	=  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$start_date 			=  $annee_excerice.'/09/01';
					$end_date   			= ((int)$annee_excerice+1).'/08/31';
					$sql 					= "date_enregistrement_livre_caisse_banque BETWEEN '".$start_date."' AND '".$end_date."'";
									
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0 ){
							$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
							}
						}

					}else{
						$sql .=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] == 'situation de la province'){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
					}else{
						$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$balance_livre_caisse_banques 	= $this->_build_categorie_sous_cat_plan_comptable_array($sous_comptable_affectee,$sql);	
					$file_export_name 			 	= 'Compte de résultat '.$entreprise_salesienne['nom_entreprise_salesienne'].' simplifié exercice '.$annee_excerice.'.pdf';
					$index_for_group_1 			 	= ( count($balance_livre_caisse_banques ['RECETTES']) >= count($balance_livre_caisse_banques ['DEPENSES']) ) ? count($balance_livre_caisse_banques ['RECETTES']) : count($balance_livre_caisse_banques ['DEPENSES']); 

					$pdf = new FPDF('L','cm','A4');

					$pdf->AddPage();
					$pdf->SetAutoPageBreak(true,2);

					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','','14');

					$pdf->Cell(27.8,1.5,iconv('UTF-8','windows-1252', strtoupper( 'COMPTE DE RESULTAT '.$entreprise_salesienne['nom_entreprise_salesienne'].' exercice '.$annee_excerice )),'',1,'L');
					$pdf->Image(base_url('assets/dore_assets').'/img/logo_salesien_bg.png',25,0.1,2.5,2.5);

					$pdf->SetFillColor(0,32,96);
					$pdf->SetTextColor(255,255,255);
					$pdf->SetFont('Times','','12');

					$pdf->Cell(13.9,1.5,'CHARGES','LTB',0,'C',true);
					$pdf->Cell(13.9,1.5,'PRODUITS','TRB',1,'C',true);

					$pdf->SetTextColor(0,0,0);
					$pdf->SetFont('Times','','11');
					$pdf->Cell(6.945,1,'DESIGNATION','LBR',0,'C');
					$pdf->Cell(6.945,1,'VALEURS NETTE $','BR',0,'C');
					$pdf->Cell(6.945,1,'DESIGNATION','LBR',0,'C');
					$pdf->Cell(6.945,1,'VALEURS NETTE $','BR',0,'C');
					$pdf->Ln();


					for ($i=0; $i < $index_for_group_1 ; $i++) { 

						if(isset($balance_livre_caisse_banques['DEPENSES'][$i])){
							$pdf->Cell(6.945,1,ellipsis(iconv('UTF-8','windows-1252',$balance_livre_caisse_banques['DEPENSES'][$i]['designation_sous_categorie_plan_comptable']),26),'LBRT',0,'C');
							$pdf->Cell(6.945,1,number_format($balance_livre_caisse_banques['DEPENSES'][$i]['solde_debiteur'],2),'LBRT',0,'C');
							$total_solde_debiteur = $total_solde_debiteur + $balance_livre_caisse_banques['DEPENSES'][$i]['solde_debiteur'];
						}else{
							$pdf->Cell(6.945,1,'','LBRT',0,'C');
							$pdf->Cell(6.945,1,'','LBRT',0,'C');
						}

						if(isset($balance_livre_caisse_banques ['RECETTES'][$i])){
							$pdf->Cell(6.945,1,ellipsis( iconv('UTF-8','windows-1252',$balance_livre_caisse_banques ['RECETTES'][$i]['designation_sous_categorie_plan_comptable']),26),'BRT',0,'C');
							$pdf->Cell(6.945,1,number_format($balance_livre_caisse_banques ['RECETTES'][$i]['solde_crebiteur'],2),'BRT',0,'C');
							$total_solde_crediteur = $total_solde_crediteur + $balance_livre_caisse_banques ['RECETTES'][$i]['solde_crebiteur'];

						}else{
							$pdf->Cell(6.945,1,'','BRT',0,'C');
							$pdf->Cell(6.945,1,'','BRT',0,'C');
						}

						$pdf->Ln();
					}

					$pdf->SetFillColor(166,166,166);
					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','B','12');

					$pdf->Cell(9,1,'TOTAL CHARGES','LBT',0,'L');
					$pdf->Cell(4.89,1,number_format($total_solde_debiteur,2).' $','BRT',0,'C');

					$pdf->Cell(9,1,'TOTAL PRODUITS','LBT',0,'L');
					$pdf->Cell(4.89,1,number_format($total_solde_crediteur,2).' $','BRT',0,'C');
					$pdf->Ln();


					$pdf->SetFillColor(0,32,96);
					$pdf->SetTextColor(255,255,255);
					$pdf->SetFont('Times','B','12');

					$pdf->Cell(13.89,1,'RESULTAT NET L\'EXERCICE ','LBT',0,'L',true);
					$pdf->Cell(13.89,1,number_format(  ($total_solde_crediteur - $total_solde_debiteur) ,2).' $','BRT',0,'R', true);

									
					$pdf->Output('D',$file_export_name);
				
				}else{
					redirect($_SERVER['HTTP_REFERER']);
				}
				
		
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}

	public function _build_sous_cat_plan_comptable_array($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$ids_sous_categorie_affectees 	= [];

		if($id_user_entreprise == "situation de la province"){
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_all_sous_categorie_comptable_affectees();
			$ids_sous_categorie_comptable_affectees = '';

			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_comptable_affectees.= $sous_categorie_affectee['id_foreign_sous_categorie'].',';
			}

			$ids_sous_categorie_comptable_affectees = substr($ids_sous_categorie_comptable_affectees,0,-1);
			$tab_ids_sous_categorie_comptable_affectees = explode(',',$ids_sous_categorie_comptable_affectees);
			$tab_ids_sous_categorie_comptable_affectees = array_unique($tab_ids_sous_categorie_comptable_affectees);
			sort($tab_ids_sous_categorie_comptable_affectees);

			$ids_sous_categorie_comptable_affectees = implode(',', $tab_ids_sous_categorie_comptable_affectees);
			$sous_categorie_affectees = [];

			$sous_categorie_affectees [0] = [
				'id_sous_categorie_comptable_affectee'=>1,
				'id_foreign_sous_categorie'=> $ids_sous_categorie_comptable_affectees,
				'id_foreign_entreprise_salesienne'=>32
			];
		
		}else{
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		}

		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees = explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				$entreprise_salesienne 			= $this->Entreprise_salesienne_model->get_entreprise_salesienne($sous_categorie_affectee['id_foreign_entreprise_salesienne']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$sous_categorie['nom_entreprise_salesienne'] = $entreprise_salesienne['nom_entreprise_salesienne'];
						$sous_categorie_affectee_result[]  = $sous_categorie;
					}
				}
			}
		}

		return $sous_categorie_affectee_result;
	}

	public function _build_categorie_sous_cat_plan_comptable_array($sous_categorie_plan_comptables , $sql = null)
	{
		$categorie_sous_cat_comptables_results = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			

			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=6000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 7999 ){

				$categorie_plan_comptable 							=  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable($sous_categorie_plan_comptable['id_foreign_categorie_plan_comptable']);
				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				
				if( (int) $categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] == 1){
					$solde_restant =  $sous_categorie_plan_comptable['total_entree'] - $sous_categorie_plan_comptable['total_sortie'] ;
				}else{
					$solde_restant =  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				}				

				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				
				if(!empty($categorie_plan_comptable) ){
					if( (int) $categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] == 1){
	
						if($solde_restant > 0 ){
							$sous_categorie_plan_comptable['solde_debiteur'] 	= 0;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= $solde_restant;
						}else{
							$sous_categorie_plan_comptable['solde_debiteur'] 	= $solde_restant;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= 0;
						}
	
						$sous_categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] = 1;
						$categorie_sous_cat_comptables_results['RECETTES'][] = $sous_categorie_plan_comptable;
	
					}else{
	
						if($solde_restant > 0 ){
							$sous_categorie_plan_comptable['solde_debiteur'] 	= $solde_restant;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= 0;
						}else{
							$sous_categorie_plan_comptable['solde_debiteur'] 	= 0;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= $solde_restant;
						}	
	
						$sous_categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] =2;
						$categorie_sous_cat_comptables_results['DEPENSES'][] = $sous_categorie_plan_comptable;

					}
				}
			}

		}

		if(isset( $categorie_sous_cat_comptables_results['RECETTES'] )){
			$key_values = array_column($categorie_sous_cat_comptables_results['RECETTES'], 'code_comptable'); 
			array_multisort($key_values, SORT_ASC, $categorie_sous_cat_comptables_results['RECETTES']);

			$key_values = array_column($categorie_sous_cat_comptables_results['DEPENSES'], 'code_comptable'); 
			array_multisort($key_values, SORT_ASC, $categorie_sous_cat_comptables_results['DEPENSES']);

			$categorie_sous_cat_comptables_results['RECETTES'] = $this->format_array($categorie_sous_cat_comptables_results['RECETTES']);
			$categorie_sous_cat_comptables_results['DEPENSES'] = $this->format_array($categorie_sous_cat_comptables_results['DEPENSES']);
		}
		

		$categorie_sous_cat_comptables_results['total_entrees'] =  $total_entrees;
		$categorie_sous_cat_comptables_results['total_sorties'] =  $total_sorties;
		return $categorie_sous_cat_comptables_results;
	}

	public function format_array($array_code_comptable_in){


		$array_code_comptable_total_entree  	= 0;
		$array_code_comptable_total_sortie  	= 0;
		$array_code_comptable_total_crediteur   = 0;
		$array_code_comptable_total_debiteur    = 0;
		$array_code_comptable_in_final   		= [];
		$designation = ''; 
		$last_code = '0000';
		
		foreach ($array_code_comptable_in as $key => $array_code_comptable) {
			$founded = 0;
			if($array_code_comptable['code_comptable'] <> $last_code){
				
				for ($i=$key; $i < count($array_code_comptable_in) ; $i++) { 
					if($array_code_comptable['code_comptable'] == $array_code_comptable_in[$i]['code_comptable']){
						$founded ++;
						$array_code_comptable_total_entree  	= $array_code_comptable_total_entree  + $array_code_comptable_in[$i]['total_entree'];
						$array_code_comptable_total_sortie  	= $array_code_comptable_total_sortie  + $array_code_comptable_in[$i]['total_sortie'];
						$array_code_comptable_total_crediteur 	= $array_code_comptable_total_crediteur + $array_code_comptable_in[$i]['solde_crebiteur'];
						$array_code_comptable_total_debiteur 	= $array_code_comptable_total_debiteur + $array_code_comptable_in[$i]['solde_debiteur'];
						$designation.= $array_code_comptable_in[$i]['designation_sous_categorie_plan_comptable'].', ';
					}
				}

				if($founded < 2){
					$array_code_comptable_in_final[] = $array_code_comptable;
				}else{
					$array_code_comptable_in_buider = [
						'id_sous_categorie_comptable'=>0,
						'designation_sous_categorie_plan_comptable'=>$designation,
						'description_sous_categorie_comptable'=>'',
						'code_comptable'=>$array_code_comptable['code_comptable'],
						'id_foreign_entreprise_salesienne'=>0,
						'id_foreign_categorie_plan_comptable'=>0,
						'nom_entreprise_salesienne'=>$array_code_comptable['nom_entreprise_salesienne'],
						'total_entree'=>$array_code_comptable_total_entree,
						'total_sortie'=>$array_code_comptable_total_sortie,
						'solde_debiteur'=>$array_code_comptable_total_debiteur,
						'solde_crebiteur'=>$array_code_comptable_total_crediteur,
					];
					$array_code_comptable_in_final[] = $array_code_comptable_in_buider;
					
				}

				$array_code_comptable_total_entree  	= 0; 
				$array_code_comptable_total_sortie  	= 0;
				$array_code_comptable_total_sortie  	= 0;
				$array_code_comptable_total_debiteur  	= 0;
				$array_code_comptable_total_crediteur 	= 0;
				$designation = '';
				$last_code = $array_code_comptable['code_comptable'];

			}
		}
		
		return $array_code_comptable_in_final;
	}

	public function _build_categorie_sous_cat_plan_comptable_array_old($sous_categorie_plan_comptables , $sql = null)
	{
		$categorie_sous_cat_comptables_results = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			

			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=6000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 7999 ){

				$categorie_plan_comptable 							=  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable($sous_categorie_plan_comptable['id_foreign_categorie_plan_comptable']);
				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				
				if( (int) $categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] == 1){
					$solde_restant =  $sous_categorie_plan_comptable['total_entree'] - $sous_categorie_plan_comptable['total_sortie'] ;
				}else{
					$solde_restant =  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				}				

				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				
				if(!empty($categorie_plan_comptable) ){
					if( (int) $categorie_plan_comptable['id_foreign_type_categorie_plan_comptable'] == 1){
	
						if($solde_restant > 0 ){
							$sous_categorie_plan_comptable['solde_debiteur'] 	= 0;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= $solde_restant;
						}else{
							$sous_categorie_plan_comptable['solde_debiteur'] 	= $solde_restant;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= 0;
						}
	
						if( isset( $categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] ) ){
							$categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
						}else{
							$categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] = $categorie_plan_comptable;
							$categorie_sous_cat_comptables_results['RECETTES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
						}
	
					}else{
	
						if($solde_restant > 0 ){
							$sous_categorie_plan_comptable['solde_debiteur'] 	= $solde_restant;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= 0;
						}else{
							$sous_categorie_plan_comptable['solde_debiteur'] 	= 0;
							$sous_categorie_plan_comptable['solde_crebiteur'] 	= $solde_restant;
						}	
	
	
						if( isset( $categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] ) ){
							$categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
						}else{
							$categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] = $categorie_plan_comptable;
							$categorie_sous_cat_comptables_results['DEPENSES'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
						}
					}
				}
			}

		}

		$categorie_sous_cat_comptables_results['total_entrees'] =  $total_entrees;
		$categorie_sous_cat_comptables_results['total_sorties'] =  $total_sorties;
		return $categorie_sous_cat_comptables_results;
	}

	public function _build_sous_cat_plan_comptable_array_old($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$ids_sous_categorie_affectees 	= [];


		if($id_user_entreprise == "situation de la province"){
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_all_sous_categorie_comptable_affectees();
		
		}else{
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		}

		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees 	= explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				$entreprise_salesienne 			= $this->Entreprise_salesienne_model->get_entreprise_salesienne($sous_categorie_affectee['id_foreign_entreprise_salesienne']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$sous_categorie['nom_entreprise_salesienne'] = $entreprise_salesienne['nom_entreprise_salesienne'];
						$sous_categorie_affectee_result[]  = $sous_categorie;
					}
				}
			}
		}
		return $sous_categorie_affectee_result;
	}

}
