<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Commande extends CI_Controller {

	public function index($id_pour_entreprise=null)
	{
		if(  $this->session->logged_in ){

			if(check_privilege('commande', $this->session->user['id_role'], 'voir')){

				$crud = new grocery_CRUD();

				$crud->where(['id_pour_entreprise'=>$id_pour_entreprise]);

				$nom_entreprise = $this->ModelGetTableRow->getObjectFieldValue(['id_entreprise'=>$id_pour_entreprise],'entreprise')->nom;
				$devise = '$';

				if( isset( $_POST['start_date'] )  AND isset($_POST['end_date'])){
					$sql = "date_com_enregistrement BETWEEN'".$_POST['start_date']."' AND '".$_POST['end_date']."' AND id_pour_entreprise = ".$_POST['id_pour_entreprise']."";
					$crud->where($sql);
				}
				
				if($id_pour_entreprise == 4){
					$devise = 'Rand';
				}

				$crud->set_table('commande');
				$crud->columns('id_commande','id_rfq_mlg','id_entreprise','prix_commande','prix_achat','marchandise','status_paiement','status_livraison','id_quotation_mlg','id_quotation_fournisseur','id_proformat_mlg','id_proformat_fournisseur','id_po_mlg','id_po_fournisseur','num_enregistrement','itineraire_livraison');
				
				$crud->display_as('id_commande','#');
				$crud->display_as('id_entreprise','Commande pour le Client');
				$crud->display_as('id_rfq_mlg','Ref. RFQ MLG');
				$crud->display_as('id_quotation_fournisseur','Ref. Quotation Fournisseur ');
				$crud->display_as('id_quotation_mlg','Ref. Quotation MLG');
				$crud->display_as('id_proformat_mlg','Ref. Proformat MLG');
				$crud->display_as('id_proformat_fournisseur','Ref. Proformat Fournisseur ');
				$crud->display_as('id_po_mlg','Ref. P.O MLG');
				$crud->display_as('id_po_fournisseur','Ref. P.O Fournisseur ');
				$crud->display_as('marchandise','Marchandise');
				$crud->display_as('prix_commande','Prix de vente '.$devise);
				$crud->display_as('prix_achat','Prix d\'achat '.$devise);
				$crud->display_as('preuve_paiement_fournisseur','Fichier preuve de paiment au fournisseur ');
				$crud->display_as('bon_livraison_fournisseur','Fichier bon de livraison fournisseur ');
				$crud->display_as('fichier_facture_gvr','Fichier GVR du client ');
				$crud->display_as('taxe_invoice','Fichier taxe invoce');
				$crud->display_as('fichier_paiement_client','Fichier Bordereau de paiement Client ');
				$crud->display_as('itineraire_livraison','Itinétaire de la livraison ');
				$crud->display_as('status_paiement','Status Paiement ');
				$crud->display_as('status_livraison','Status Livraison');
				$crud->display_as('date_com_enregistrement',' Date d\'enregistrement');
				$crud->display_as('date_livraison','date de livraison');
				$crud->display_as('num_enregistrement','Ref. Commande ');
				
				$crud->set_subject('Une Commande');

				$crud->add_fields(
					array(
					'num_enregistrement',
					'id_entreprise',
					'id_rfq_mlg',
					'id_quotation_mlg',
					'id_quotation_fournisseur',
					'id_proformat_mlg',
					'id_proformat_fournisseur',
					'id_po_mlg',
					'id_po_fournisseur',
					'marchandise',
					'prix_commande',
					'prix_achat',
					'status_paiement',
					'status_livraison',
					'preuve_paiement_fournisseur',
					'bon_livraison_fournisseur',
					'fichier_facture_gvr',
					'taxe_invoice',
					'fichier_paiement_client',
					'itineraire_livraison',
					'date_livraison',
					'date_com_enregistrement',
					'id_pour_entreprise'
					)
				);

				$crud->edit_fields(
					array(
					'num_enregistrement',
					'id_entreprise',
					'id_rfq_mlg',
					'id_quotation_mlg',
					'id_quotation_fournisseur',
					'id_proformat_mlg',
					'id_proformat_fournisseur',
					'id_po_mlg',
					'id_po_fournisseur',
					'marchandise',
					'prix_commande',
					'prix_achat',
					'status_paiement',
					'status_livraison',
					'preuve_paiement_fournisseur',
					'bon_livraison_fournisseur',
					'fichier_facture_gvr',
					'taxe_invoice',
					'fichier_paiement_client',
					'itineraire_livraison',
					'date_livraison',
					'date_com_enregistrement',
					'id_pour_entreprise'
					)
				);
				

				$crud->callback_before_insert(array($this,'_onRowBeforeInserted'));
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_before_update(array($this,'_onRowBeforeUpdated'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
				
				//$crud->callback_column('id_quotation_mlg',array($this,'show_quotation'));
				

				$crud->set_relation('id_entreprise','entreprise','nom','is_systeme <>1');
				$crud->set_relation('id_rfq_mlg','rfq_mlg','ref_rfq_mgl');
				$crud->set_relation('id_quotation_mlg','quotation_mlg','num_quotation','id_quot_pour_entreprise ='.$id_pour_entreprise.'');
				$crud->set_relation('id_proformat_mlg','proformat_mlg','ref_proformat_mlg','id_proformat_pour_entreprise_mlg ='.$id_pour_entreprise.'');
				$crud->set_relation('id_po_mlg','po_mlg','ref_po_mlg','id_po_pour_entreprise_mlg ='.$id_pour_entreprise.'');
				$crud->set_relation('status_paiement','status_commande','designation');
				$crud->set_relation('status_livraison','status_livraison','designation');

				$crud->set_relation_n_n('id_quotation_fournisseur', 'commande_quotation_fournisseur', 'quotation_fournisseur', 'id_commande', 'id_quotation_fournisseur', 'num_quotation_fournisseur',null,array('id_quot_pour_entreprise'=>$id_pour_entreprise) );
				$crud->set_relation_n_n('id_proformat_fournisseur', 'commande_proformat_fournisseur', 'proformat_fournisseur', 'id_commande', 'id_proformat_fournisseur', 'ref_proformat_fournisseur',null,array('id_proformat_pour_entreprise_fournisseur'=>$id_pour_entreprise) );
				$crud->set_relation_n_n('id_po_fournisseur', 'commande_po_fournisseur', 'po_fournisseur', 'id_commande', 'id_po_fournisseur', 'ref_po_fournisseur',null,array('id_po_pour_entreprise_fournisseur'=>$id_pour_entreprise) );

				


				$crud->set_field_upload('preuve_paiement_fournisseur','assets/uploads/files');
				$crud->set_field_upload('bon_livraison_fournisseur','assets/uploads/files');
				$crud->set_field_upload('fichier_facture_gvr','assets/uploads/files');
				$crud->set_field_upload('taxe_invoice','assets/uploads/files');
				$crud->set_field_upload('fichier_paiement_client','assets/uploads/files');
				$crud->set_field_upload('fichier_facture','assets/uploads/files');

				$crud->field_type('id_pour_entreprise', 'hidden',$id_pour_entreprise);

				$crud->required_fields(
					'id_entreprise',
					'status_paiement',
					'status_livraison',
					'prix_commande',
					'num_enregistrement',
					'id_rfq_mlg',
					'id_quotation_mlg',
					'id_quotation_fournisseur',
					'id_proformat_mlg',
					'id_proformat_fournisseur',
					'id_po_mlg',
					'id_po_fournisseur',
					'marchandise'
				);	

				$crud->unset_clone();
				$this->stateDisplay($crud);

				if( ! check_privilege('commande', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('commande', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('commande', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('commande', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				if(  check_privilege('finance', $this->session->user['id_role'], 'voir') ){
					$crud->add_action('Dépenses', '', '', 'fa-money',array($this,'return_link_to_depense'));
				}
				
				$crud->order_by('id_commande','desc');

				$output = $crud->render();

				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/navbar", [], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("commande/commande", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'id_pour_entreprise'=>$id_pour_entreprise,'devise'=>$devise,'nom_entreprise'=>$nom_entreprise,'output'=>$output->output]);
		

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}
		}else {
			redirect("Starter/login");
		}
	
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une commande ");
				break;
			case 'list':
				$crud->set_subject("Une commande");				
				break;
			case 'add':
				//$crud->field_type('num_enregistrement', 'hidden');
				$crud->field_type('date_com_enregistrement', 'hidden');
				$crud->field_type('date_livraison', 'hidden');
				break;
			
			case 'edit':
				//$crud->field_type('num_enregistrement', 'hidden');
				$crud->field_type('date_com_enregistrement', 'hidden');
				$crud->field_type('date_livraison', 'hidden');
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowBeforeInserted($post_array)
	{
		//$post_array['num_enregistrement'] = rand(100000, 999999);
		$post_array['date_com_enregistrement'] = date("Y-m-d H:m:s");
		return $post_array;
	}


	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Commande ',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'Une commande ".$post_array["num_enregistrement"],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}


	public function _onRowBeforeUpdated($post_array,$primary_key)
	{
		if($post_array['status_livraison']  == 2){
			$post_array['date_livraison'] = date("Y-m-d H:m:s");
		}
		
		return $post_array;
	}


	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Commande',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour de la commande  ".$post_array["num_enregistrement"],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_commande'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Commande',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "suppression de la commande ".$this->ModelGetTableRow->getObjectFieldValue($data,'commmande')->num_enregistrement,
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	function return_link_to_depense($primary_key , $row){
		return site_url('Depense/index/commande/'.$row->id_commande.'/prix_commande/'.$row->id_pour_entreprise);
	}
	
	public function show_quotation($value, $row)
	{
		if($row->id_quotation <> null OR $row->id_quotation<> 0){
			return "<a href='".site_url('Quotation/index/'.$row->id_pour_entreprise.'/read/'.$row->	id_quotation)."' target='__blank'> voir la id_quotation_mlg </a>";
		}else{
			return "Aucune Quotation disponible";
		}
	}

}
