<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT");

defined('BASEPATH') OR exit('No direct script access allowed');

class Balance extends CI_Controller {

	public function index($id_year=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('balance', $this->session->user['id_role'], 'voir')){


				$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes();
				$entreprise_salesienne      = [];
				$id_entreprise_salesienne 	= (int) $_SESSION['user']['id_foreign_entreprise_salesienne'];
				$sous_comptable_affectee 	= null;
				$current_month_date 		= "";
				$next_month_date 			= "";
				$current_year_date 			= "";
				$next_year_date 			= "";
				$annee_excerice 			= null;
				$annee_excerice_next		= null;
				$balance_link_active 		= "link_menu_active";
				$balance_livre_caisse_banques = null;

			
				if( isset( $_POST['annee_exercice'] ) OR ( isset($id_year) AND $id_year <> null )  ){

					$annee_excerice 	 	=  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$annee_excerice_next 	=  (int) $annee_excerice + 1;
					$start_date 			=  $annee_excerice.'/09/01';
					$end_date   			= ((int)$annee_excerice+1).'/08/31';

					$sql =" date_enregistrement_livre_caisse_banque BETWEEN '$start_date' AND '$end_date'";
					$sql_amortissement 	=" date_enregistrement_livre_caisse_banque <= '$end_date' ";

					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
							$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
							}
						}
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];

					}else{
						$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}


					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] == 'situation de la province'){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
					}else{
						$entreprise_salesienne	 		= $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}
					

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$balance_livre_caisse_banques 	= $this->_build_categorie_sous_cat_plan_comptable_array($sous_comptable_affectee,$sql,$sql_amortissement);	
					
				}

				
				$crud = new grocery_CRUD();
				$crud->set_table('sexe');
				$output = $crud->render();

				$header 	= $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar 	= $this->load->view("layouts/sidebar", [], true);
				$navbar 	= $this->load->view("layouts/menu_nav_bar", ['balance_link_active'=>$balance_link_active], true);
				$footer 	= $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$b_header 	= $this->load->view("balance/balance_header", [], true);
				$b_footer 	= $this->load->view("balance/balance_footer", [], true);

				$this->load->view("balance/balance", [
					'header' 	=> 	$header, 
					'navbar'	=>	$navbar, 
					'sidebar' 	=> 	$sidebar, 
					'footer' 	=> 	$footer,
					'b_header' 	=> 	$b_header,
					'b_footer' 	=> 	$b_footer,
					'output'=>$output->output,
					'annee_excerice' 	=> 	$annee_excerice,
					'annee_excerice_next' 	=> 	$annee_excerice_next,
					'current_year_date' 	=> 	$current_year_date,
					'next_year_date' 	=> 	$next_year_date,
					'current_month_date' 	=> 	$current_month_date,
					'next_month_date' 	=> 	$next_month_date,
					'oeuvre_don_bosco' 		=> 	$entreprise_salesienne,
					'entreprise_salesiennes' 		=> 	$entreprise_salesiennes,
					'balance_livre_caisse_banques' 	=> 	$balance_livre_caisse_banques,
				]);
		
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}


	public function _build_sous_cat_plan_comptable_array($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$ids_sous_categorie_affectees 	= [];

		if($id_user_entreprise == "situation de la province"){
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_all_sous_categorie_comptable_affectees();
			$ids_sous_categorie_comptable_affectees = '';

			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_comptable_affectees.= $sous_categorie_affectee['id_foreign_sous_categorie'].',';
			}

			$ids_sous_categorie_comptable_affectees = substr($ids_sous_categorie_comptable_affectees,0,-1);
			$tab_ids_sous_categorie_comptable_affectees = explode(',',$ids_sous_categorie_comptable_affectees);
			$tab_ids_sous_categorie_comptable_affectees = array_unique($tab_ids_sous_categorie_comptable_affectees);
			sort($tab_ids_sous_categorie_comptable_affectees);

			$ids_sous_categorie_comptable_affectees = implode(',', $tab_ids_sous_categorie_comptable_affectees);
			$sous_categorie_affectees = [];

			$sous_categorie_affectees [0] = [
				'id_sous_categorie_comptable_affectee'=>1,
				'id_foreign_sous_categorie'=> $ids_sous_categorie_comptable_affectees,
				'id_foreign_entreprise_salesienne'=>32
			];
		
		}else{
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		}

		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees = explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				$entreprise_salesienne 			= $this->Entreprise_salesienne_model->get_entreprise_salesienne($sous_categorie_affectee['id_foreign_entreprise_salesienne']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$sous_categorie['nom_entreprise_salesienne'] = $entreprise_salesienne['nom_entreprise_salesienne'];
						$sous_categorie_affectee_result[]  = $sous_categorie;
					}
				}
			}
		}

		return $sous_categorie_affectee_result;
	}

	public function _build_categorie_sous_cat_plan_comptable_array($sous_categorie_plan_comptables , $sql = null, $sql_amortissement=null)
	{
		$categorie_sous_cat_comptables_results = [];
		$total_crediteur 	= 0;
		$total_dediteur 	= 0;
		$total_solde_crediteur 	= 0;
		$total_solde_dediteur 	= 0;
		$final_sql 		= '';
		$solde_restant 	= 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {

			$categorie_plan_comptable =  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable($sous_categorie_plan_comptable['id_foreign_categorie_plan_comptable']);
			
			if( ((int) $sous_categorie_plan_comptable['code_comptable'] >=1000)  AND ((int) $sous_categorie_plan_comptable['code_comptable'] <=5999) ){
				$final_sql = $sql_amortissement;
			}else{
				$final_sql = $sql; 
			}

			$sous_categorie_plan_comptable['total_credit'] 		=  $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$final_sql);
			$sous_categorie_plan_comptable['total_debit'] 		=  $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$final_sql);
			$sous_categorie_plan_comptable['total_credit'] 		= ( empty($sous_categorie_plan_comptable['total_credit']) ) ? 0 : $sous_categorie_plan_comptable['total_credit'];
			$sous_categorie_plan_comptable['total_debit'] 		= ( empty($sous_categorie_plan_comptable['total_debit']) )  ? 0 : $sous_categorie_plan_comptable['total_debit'];
			


						
			if( 
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=1000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=1999  AND (int) $sous_categorie_plan_comptable['code_comptable'] <>1310 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=4000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4099 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=4200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4499 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=7000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=7999 )
			  )
			{

				if( 
					( (int) $sous_categorie_plan_comptable['code_comptable'] >=1000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=1999 )
					OR
					( (int) $sous_categorie_plan_comptable['code_comptable'] >=4000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4099 ) 
					OR
					( (int) $sous_categorie_plan_comptable['code_comptable'] >=4200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4499 ) 
				  )
				{
					$solde_restant =  $sous_categorie_plan_comptable['total_debit'] - $sous_categorie_plan_comptable['total_credit'] ;
					$credit =  $sous_categorie_plan_comptable['total_debit'];
					$sous_categorie_plan_comptable['total_debit'] = $sous_categorie_plan_comptable['total_credit'];
					$sous_categorie_plan_comptable['total_credit']  = $credit;
				}else{
					$solde_restant =  $sous_categorie_plan_comptable['total_credit'] - $sous_categorie_plan_comptable['total_debit'] ;
				}

				
				if($solde_restant >0 ){
					$sous_categorie_plan_comptable['solde_credit']  = $solde_restant; 
					$sous_categorie_plan_comptable['solde_dedit']   = 0; 

				}else{
					$sous_categorie_plan_comptable['solde_credit']  = 0; 
					$sous_categorie_plan_comptable['solde_dedit']   = $solde_restant; 
				}
	
				if(!empty($categorie_plan_comptable)){
					$categorie_sous_cat_comptables_results['COMPTE_CREDITEUR'][] = $sous_categorie_plan_comptable;
				}

			}else{

				
				if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=5100 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=5999 ) ){
					$solde_restant =  $sous_categorie_plan_comptable['total_credit'] - $sous_categorie_plan_comptable['total_debit'] ;
					$debit =  $sous_categorie_plan_comptable['total_credit'];
					$sous_categorie_plan_comptable['total_credit'] = $sous_categorie_plan_comptable['total_debit'];
					$sous_categorie_plan_comptable['total_debit']  = $debit;
				}else{
					$solde_restant =  $sous_categorie_plan_comptable['total_debit'] - $sous_categorie_plan_comptable['total_credit'] ;
				}

				if($solde_restant >0 ){
					$sous_categorie_plan_comptable['solde_dedit']   = $solde_restant; 
					$sous_categorie_plan_comptable['solde_credit']  = 0; 

				}else{
					$sous_categorie_plan_comptable['solde_dedit']   = 0; 
					$sous_categorie_plan_comptable['solde_credit']  = $solde_restant; 
				}

				if(!empty($categorie_plan_comptable)){
					$categorie_sous_cat_comptables_results['COMPTE_DEBITEUR'][] = $sous_categorie_plan_comptable;

				}
			}
			
			$total_crediteur	= $total_crediteur + $sous_categorie_plan_comptable['total_credit'];					
			$total_dediteur   	= $total_dediteur  + $sous_categorie_plan_comptable['total_debit'];
			
			$total_solde_crediteur	= $total_solde_crediteur + $sous_categorie_plan_comptable['solde_credit'];
			$total_solde_dediteur	= $total_solde_dediteur  + $sous_categorie_plan_comptable['solde_dedit'];
	
		}

		$key_values = array_column($categorie_sous_cat_comptables_results['COMPTE_CREDITEUR'], 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $categorie_sous_cat_comptables_results['COMPTE_CREDITEUR']);

		$key_values = array_column($categorie_sous_cat_comptables_results['COMPTE_DEBITEUR'], 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $categorie_sous_cat_comptables_results['COMPTE_DEBITEUR']);

		$categorie_sous_cat_comptables_results['COMPTE_CREDITEUR']  = $this->format_array($categorie_sous_cat_comptables_results['COMPTE_CREDITEUR']);
		$categorie_sous_cat_comptables_results['COMPTE_DEBITEUR']   = $this->format_array($categorie_sous_cat_comptables_results['COMPTE_DEBITEUR']);

		//echoDie($categorie_sous_cat_comptables_results);


		$categorie_sous_cat_comptables_results['total_crediteur'] 	=  $total_crediteur;
		$categorie_sous_cat_comptables_results['total_dediteur'] 	=  $total_dediteur;
		$categorie_sous_cat_comptables_results['total_solde_crediteur'] =  $total_solde_crediteur;
		$categorie_sous_cat_comptables_results['total_solde_dediteur'] 	=  $total_solde_dediteur;
		return $categorie_sous_cat_comptables_results;
		
	}



	public function _build_categorie_sous_cat_plan_comptable_array_old($sous_categorie_plan_comptables , $sql = null, $sql_amortissement=null)
	{
		$categorie_sous_cat_comptables_results = [];
		$total_crediteur 	= 0;
		$total_dediteur 	= 0;
		$total_solde_crediteur 	= 0;
		$total_solde_dediteur 	= 0;
		$final_sql 		= '';
		$solde_restant 	= 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {

			$categorie_plan_comptable =  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable($sous_categorie_plan_comptable['id_foreign_categorie_plan_comptable']);
			
			if( ((int) $sous_categorie_plan_comptable['code_comptable'] >=1000)  AND ((int) $sous_categorie_plan_comptable['code_comptable'] <=5999) ){
				$final_sql = $sql_amortissement;
			}else{
				$final_sql = $sql; 
			}

			$sous_categorie_plan_comptable['total_credit'] 		=  $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$final_sql);
			$sous_categorie_plan_comptable['total_debit'] 		=  $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$final_sql);
			$sous_categorie_plan_comptable['total_credit'] 		= ( empty($sous_categorie_plan_comptable['total_credit']) ) ? 0 : $sous_categorie_plan_comptable['total_credit'];
			$sous_categorie_plan_comptable['total_debit'] 		= ( empty($sous_categorie_plan_comptable['total_debit']) )  ? 0 : $sous_categorie_plan_comptable['total_debit'];
			


						
			if( 
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=1000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=1999  AND (int) $sous_categorie_plan_comptable['code_comptable'] <>1310 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=4000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4099 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=4200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4499 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=7000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=7999 )
			  )
			{

				if( 
					( (int) $sous_categorie_plan_comptable['code_comptable'] >=1000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=1999 )
					OR
					( (int) $sous_categorie_plan_comptable['code_comptable'] >=4000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4099 ) 
					OR
					( (int) $sous_categorie_plan_comptable['code_comptable'] >=4200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=4499 ) 
				  )
				{
					$solde_restant =  $sous_categorie_plan_comptable['total_debit'] - $sous_categorie_plan_comptable['total_credit'] ;
					$credit =  $sous_categorie_plan_comptable['total_debit'];
					$sous_categorie_plan_comptable['total_debit'] = $sous_categorie_plan_comptable['total_credit'];
					$sous_categorie_plan_comptable['total_credit']  = $credit;
				}else{
					$solde_restant =  $sous_categorie_plan_comptable['total_credit'] - $sous_categorie_plan_comptable['total_debit'] ;
				}

				
				if($solde_restant >0 ){
					$sous_categorie_plan_comptable['solde_credit']  = $solde_restant; 
					$sous_categorie_plan_comptable['solde_dedit']   = 0; 

				}else{
					$sous_categorie_plan_comptable['solde_credit']  = 0; 
					$sous_categorie_plan_comptable['solde_dedit']   = $solde_restant; 
				}
	
				if(!empty($categorie_plan_comptable)){
					if( isset( $categorie_sous_cat_comptables_results['COMPTE_CREDITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] ) ){
						$categorie_sous_cat_comptables_results['COMPTE_CREDITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}else{
						$categorie_sous_cat_comptables_results['COMPTE_CREDITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] = $categorie_plan_comptable;
						$categorie_sous_cat_comptables_results['COMPTE_CREDITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}
				}

			}else{

				
				if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=5100 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=5999 ) ){
					$solde_restant =  $sous_categorie_plan_comptable['total_credit'] - $sous_categorie_plan_comptable['total_debit'] ;
					$debit =  $sous_categorie_plan_comptable['total_credit'];
					$sous_categorie_plan_comptable['total_credit'] = $sous_categorie_plan_comptable['total_debit'];
					$sous_categorie_plan_comptable['total_debit']  = $debit;
				}else{
					$solde_restant =  $sous_categorie_plan_comptable['total_debit'] - $sous_categorie_plan_comptable['total_credit'] ;
				}

				if($solde_restant >0 ){
					$sous_categorie_plan_comptable['solde_dedit']   = $solde_restant; 
					$sous_categorie_plan_comptable['solde_credit']  = 0; 

				}else{
					$sous_categorie_plan_comptable['solde_dedit']   = 0; 
					$sous_categorie_plan_comptable['solde_credit']  = $solde_restant; 
				}

				if(!empty($categorie_plan_comptable)){
					if( isset( $categorie_sous_cat_comptables_results['COMPTE_DEBITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] ) ){
						$categorie_sous_cat_comptables_results['COMPTE_DEBITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}else{
						$categorie_sous_cat_comptables_results['COMPTE_DEBITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ] = $categorie_plan_comptable;
						$categorie_sous_cat_comptables_results['COMPTE_DEBITEUR'][$categorie_plan_comptable['id_categorie_plan_comptable'] ]['SOUSCAT'][] = $sous_categorie_plan_comptable;
					}
				}
			}
			
			$total_crediteur	= $total_crediteur + $sous_categorie_plan_comptable['total_credit'];					
			$total_dediteur   	= $total_dediteur  + $sous_categorie_plan_comptable['total_debit'];
			
			$total_solde_crediteur	= $total_solde_crediteur + $sous_categorie_plan_comptable['solde_credit'];
			$total_solde_dediteur	= $total_solde_dediteur  + $sous_categorie_plan_comptable['solde_dedit'];
	
		}

		$categorie_sous_cat_comptables_results['total_crediteur'] 	=  $total_crediteur;
		$categorie_sous_cat_comptables_results['total_dediteur'] 	=  $total_dediteur;
		$categorie_sous_cat_comptables_results['total_solde_crediteur'] =  $total_solde_crediteur;
		$categorie_sous_cat_comptables_results['total_solde_dediteur'] 	=  $total_solde_dediteur;
		return $categorie_sous_cat_comptables_results;
		
	}
	

	public function format_array($array_code_comptable_in){


		$array_code_comptable_total_entree  	= 0;
		$array_code_comptable_total_sortie  	= 0;
		$array_code_comptable_total_crediteur   = 0;
		$array_code_comptable_total_debiteur    = 0;
		$array_code_comptable_in_final   		= [];
		$designation = ''; 
		$last_code = '0000';
		
		foreach ($array_code_comptable_in as $key => $array_code_comptable) {
			$founded = 0;
			if($array_code_comptable['code_comptable'] <> $last_code){
				
				for ($i=$key; $i < count($array_code_comptable_in) ; $i++) { 
					if($array_code_comptable['code_comptable'] == $array_code_comptable_in[$i]['code_comptable']){
						$founded ++;
						$array_code_comptable_total_entree  	= $array_code_comptable_total_entree  + $array_code_comptable_in[$i]['total_debit'];
						$array_code_comptable_total_sortie  	= $array_code_comptable_total_sortie  + $array_code_comptable_in[$i]['total_credit'];
						$array_code_comptable_total_crediteur 	= $array_code_comptable_total_crediteur + $array_code_comptable_in[$i]['solde_credit'];
						$array_code_comptable_total_debiteur 	= $array_code_comptable_total_debiteur + $array_code_comptable_in[$i]['solde_dedit'];
						$designation.= $array_code_comptable_in[$i]['designation_sous_categorie_plan_comptable'].', ';
					}
				}

				if($founded < 2){
					$array_code_comptable_in_final[] = $array_code_comptable;
				}else{
					$array_code_comptable_in_buider = [
						'id_sous_categorie_comptable'=>0,
						'designation_sous_categorie_plan_comptable'=>$designation,
						'description_sous_categorie_comptable'=>'',
						'code_comptable'=>$array_code_comptable['code_comptable'],
						'id_foreign_entreprise_salesienne'=>0,
						'id_foreign_categorie_plan_comptable'=>0,
						'nom_entreprise_salesienne'=>$array_code_comptable['nom_entreprise_salesienne'],
						'total_credit'=>$array_code_comptable_total_sortie,
						'total_debit'=>$array_code_comptable_total_entree,
						'solde_dedit'=>$array_code_comptable_total_debiteur,
						'solde_credit'=>$array_code_comptable_total_crediteur,
					];
					$array_code_comptable_in_final[] = $array_code_comptable_in_buider;
					
				}

				$array_code_comptable_total_entree  	= 0; 
				$array_code_comptable_total_sortie  	= 0;
				$array_code_comptable_total_sortie  	= 0;
				$array_code_comptable_total_debiteur  	= 0;
				$array_code_comptable_total_crediteur 	= 0;
				$designation = '';
				$last_code = $array_code_comptable['code_comptable'];

			}
		}
		
		return $array_code_comptable_in_final;
	}


}
