<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Agent extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('agent', $this->session->user['id_role'], 'voir')){


				$crud = new grocery_CRUD();

				$crud->set_table('agent');
				$crud->columns('id_agent','nom_agent','prenom_agent','photo_agent','mat_agent','id_sexe','id_etat_civil','date_naissance_agent','lieu_naissance_agent','phone1_agent','phone2_agent','id_entreprise_agent');

				$crud->display_as('id_agent','#');
				$crud->display_as('nom_agent','Nom');
				$crud->display_as('prenom_agent','Prénom');
				$crud->display_as('photo_agent','Photo');
				$crud->display_as('mat_agent','Matricule');
				$crud->display_as('date_naissance_agent','Date de Naissance');
				$crud->display_as('lieu_naissance_agent','Né à ');
				$crud->display_as('phone1_agent','Tél 1');
				$crud->display_as('phone2_agent','Tél 2');
				$crud->display_as('id_entreprise_agent','Affecté chez');
				$crud->display_as('id_sexe','sexe');
				$crud->display_as('id_etat_civil','Etat_civil');
				$crud->display_as('date_enregistrement_agent','Date d\'enregistrement');
				$crud->set_subject('Un Agent');
	
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
	
				$crud->required_fields('email','nom','nom_agent','prenom_agent','mat_agent','id_entreprise_agent');
				$crud->unique_fields(array('mat_agent'));
				$crud->field_type('date_enregistrement_agent', 'hidden',2);
				$crud->set_field_upload('photo_agent','assets/uploads/files');
				$crud->set_field_upload('fichier_agent','assets/uploads/files');
				$crud->set_relation('id_sexe','sexe','designation');
				$crud->set_relation('id_etat_civil','etat_civil','designation');
				$crud->set_relation_n_n('id_entreprise_agent', 'agent_entreprise', 'entreprise', 'id_agent', 'id_entreprise', 'nom',null,array('is_systeme'=>1) );
				$crud->unset_clone();
				$this->stateDisplay($crud);

				if( ! check_privilege('agent', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('agent', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('agent', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('agent', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}
	
				$crud->order_by('id_agent','desc');

				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/navbar", [], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("agent/agent", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->callback_field('photo_agent',array($this,'_showImage'));
				$crud->set_subject("Un Agent ");
				break;
			case 'list':
				$crud->set_subject("Un Agent ");
				$crud->callback_field('photo_agent',array($this,'_showImage'));
				break;
			case 'add':
				$crud->set_subject("D'Un Agent ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Un Agent ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Agent',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout de l'agent ".$post_array["nom_agent"],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Agent',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour de l'agent ".$post_array["nom_agent"],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['intIdEntreprise'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Agent',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "suppression d'agent ".$this->ModelGetTableRow->getObjectFieldValue($data,'entreprise')->nom_agent,
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	
}
